/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.amqp.AbstractHonoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericReceiverLink
extends AbstractHonoClient {
    private static final Logger LOG = LoggerFactory.getLogger(GenericReceiverLink.class);

    private GenericReceiverLink(HonoConnection connection, ProtonReceiver receiver) {
        super(connection);
        this.receiver = Objects.requireNonNull(receiver);
    }

    public static Future<GenericReceiverLink> create(HonoConnection con, String sourceAddress, BiConsumer<ProtonDelivery, Message> messageConsumer, boolean autoAccept, Handler<String> closeHook) {
        Objects.requireNonNull(con);
        Objects.requireNonNull(sourceAddress);
        Objects.requireNonNull(messageConsumer);
        int preFetchSize = con.getConfig().getInitialCredits();
        return con.createReceiver(sourceAddress, ProtonQoS.AT_LEAST_ONCE, messageConsumer::accept, preFetchSize, autoAccept, closeHook).map(receiver -> new GenericReceiverLink(con, (ProtonReceiver)receiver));
    }

    public final Future<Void> close() {
        LOG.debug("closing receiver ...");
        return this.closeLinks();
    }
}

