/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.app;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.eclipse.hono.cli.app.AbstractApplicationClient;
import org.eclipse.hono.client.CommandClient;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.util.BufferResult;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"command"})
public class Commander
extends AbstractApplicationClient {
    private final Scanner scanner = new Scanner(System.in);
    @Value(value="${command.timeoutInSeconds}")
    private int requestTimeoutInSecs;
    private WorkerExecutor workerExecutor;

    @PostConstruct
    void start() {
        this.workerExecutor = this.vertx.createSharedWorkerExecutor("user-input-pool", 3, TimeUnit.HOURS.toNanos(1L));
        this.clientFactory.connect().setHandler(connectAttempt -> {
            if (connectAttempt.succeeded()) {
                this.clientFactory.addReconnectListener(this::startCommandClient);
                this.startCommandClient((HonoConnection)connectAttempt.result());
            } else {
                this.close(connectAttempt.cause());
            }
        });
    }

    private void startCommandClient(HonoConnection connection) {
        this.getCommandFromUser().compose(this::processCommand).setHandler(sendAttempt -> this.startCommandClient(connection));
    }

    private Future<Void> processCommand(Command command) {
        Future commandClient = this.clientFactory.getOrCreateCommandClient(this.tenantId);
        return commandClient.map(this::setRequestTimeOut).compose(c -> {
            if (command.isOneWay()) {
                this.log.info("Command sent to device");
                return c.sendOneWayCommand(this.deviceId, command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), null).map(ok -> c);
            }
            this.log.info("Command sent to device... [waiting for response for max. {} seconds]", (Object)this.requestTimeoutInSecs);
            return c.sendCommand(this.deviceId, command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), null).map(this::printResponse).map(ok -> c);
        }).map(this::closeCommandClient).otherwise(error -> {
            if (ServerErrorException.extractStatusCode((Throwable)error) == 503) {
                this.log.error("Error sending command (error code 503). Is the device really waiting for a command? (device [{}] in tenant [{}])", (Object)this.deviceId, (Object)this.tenantId);
            } else {
                this.log.error("Error sending command: {}", (Object)error.getMessage());
            }
            if (commandClient.succeeded()) {
                return this.closeCommandClient((CommandClient)commandClient.result());
            }
            return null;
        });
    }

    private CommandClient setRequestTimeOut(CommandClient commandClient) {
        commandClient.setRequestTimeout(TimeUnit.SECONDS.toMillis(this.requestTimeoutInSecs));
        return commandClient;
    }

    private Void closeCommandClient(CommandClient commandClient) {
        this.log.trace("Close command connection to device [{}:{}]", (Object)this.tenantId, (Object)this.deviceId);
        commandClient.close(closeHandler -> {});
        return null;
    }

    private Void printResponse(BufferResult result) {
        this.log.info("Received Command response : {}", (Object)Optional.ofNullable((Buffer)result.getPayload()).orElse(Buffer.buffer()));
        return null;
    }

    private Future<Command> getCommandFromUser() {
        Future commandFuture = Future.future();
        this.workerExecutor.executeBlocking(userInputFuture -> {
            System.out.println();
            System.out.println();
            System.out.printf(">>>>>>>>> Enter name of command for device [%s] in tenant [%s] (prefix with 'ow:' to send one-way command):", this.deviceId, this.tenantId);
            System.out.println();
            String honoCmd = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter command payload:");
            String honoPayload = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter content type:");
            String honoContentType = this.scanner.nextLine();
            System.out.println();
            userInputFuture.complete((Object)new Command(honoCmd, honoPayload, honoContentType));
        }, (Handler)commandFuture);
        return commandFuture;
    }

    private void close(Throwable t) {
        this.workerExecutor.close();
        this.vertx.close();
        this.log.error("Error: {}", (Object)t.getMessage());
    }

    private static class Command {
        private final String name;
        private final String payload;
        private final String contentType;
        private final boolean oneWay;

        Command(String command, String payload, String contentType) {
            this.oneWay = command.startsWith("ow:");
            this.name = this.oneWay ? command.substring(3) : command;
            this.payload = payload;
            this.contentType = contentType;
        }

        private boolean isOneWay() {
            return this.oneWay;
        }

        private String getName() {
            return this.name;
        }

        private String getPayload() {
            return this.payload;
        }

        private String getContentType() {
            return this.contentType;
        }
    }
}

