/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonSender;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.cli.AbstractCliClient;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"amqp-adapter-cli"})
public class AmqpSend
extends AbstractCliClient {
    private ClientConfigProperties properties = new ClientConfigProperties();
    @Value(value="${message.address}")
    private String messageAddress;
    @Value(value="${message.payload}")
    private String payload;
    private ProtonConnection adapterConnection;

    @Autowired(required=false)
    public void setClientConfig(ClientConfigProperties props) {
        this.properties = Objects.requireNonNull(props);
    }

    @PostConstruct
    void start() {
        CompletableFuture messageSent = new CompletableFuture();
        Message message = ProtonHelper.message((String)this.messageAddress, (String)this.payload);
        this.ctx.runOnContext(go -> this.connectToAdapter().compose(con -> {
            this.adapterConnection = con;
            Future senderTracker = Future.future();
            ProtonSender sender = this.adapterConnection.createSender(null);
            sender.openHandler((Handler)senderTracker);
            sender.open();
            return senderTracker;
        }).map(sender -> {
            sender.send(message, delivery -> {
                this.adapterConnection.close();
                messageSent.complete(delivery);
            });
            return sender;
        }).otherwise(t -> {
            messageSent.completeExceptionally((Throwable)t);
            return null;
        }));
        PrintWriter pw = new PrintWriter(System.out);
        try {
            ProtonDelivery delivery = (ProtonDelivery)messageSent.join();
            pw.println();
            this.printDelivery(delivery, pw);
        }
        catch (CompletionException e) {
            pw.println(e.getCause());
            pw.flush();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        System.exit(0);
    }

    private void printDelivery(ProtonDelivery delivery, PrintWriter pw) {
        DeliveryState state = delivery.getRemoteState();
        pw.println(state.getType());
        switch (state.getType()) {
            case Rejected: {
                Rejected rejected = (Rejected)state;
                if (rejected.getError() == null) break;
                pw.println(rejected.getError().getCondition() + ": " + rejected.getError().getDescription());
                break;
            }
        }
        pw.flush();
    }

    private Future<ProtonConnection> connectToAdapter() {
        Future connectAttempt = Future.future();
        ProtonClientOptions options = new ProtonClientOptions();
        ProtonClient client = ProtonClient.create((Vertx)this.vertx);
        options.setConnectTimeout(this.properties.getConnectTimeout());
        options.setHeartbeat(this.properties.getHeartbeatInterval());
        Optional.ofNullable(this.properties.getAmqpHostname()).ifPresent(s -> options.setVirtualHost(s));
        if (!Strings.isNullOrEmpty((Object)this.properties.getUsername()) && !Strings.isNullOrEmpty((Object)this.properties.getPassword())) {
            options.addEnabledSaslMechanism("PLAIN");
            this.LOG.info("connecting to AMQP adapter using SASL PLAIN [host: {}, port: {}, username: {}]", new Object[]{this.properties.getHost(), this.properties.getPort(), this.properties.getUsername()});
            client.connect(options, this.properties.getHost(), this.properties.getPort(), this.properties.getUsername(), this.properties.getPassword(), (Handler)connectAttempt);
        } else {
            if (this.properties.getKeyCertOptions() != null && this.properties.getTrustOptions() != null) {
                options.setSsl(true);
                options.setKeyCertOptions(this.properties.getKeyCertOptions());
                options.setTrustOptions(this.properties.getTrustOptions());
            }
            this.LOG.info("connecting to AMQP adapter [host: {}, port: {}]", (Object)this.properties.getHost(), (Object)this.properties.getPort());
            client.connect(options, this.properties.getHost(), this.properties.getPort(), (Handler)connectAttempt);
        }
        return connectAttempt.compose(unopenedConnection -> {
            Future con = Future.future();
            unopenedConnection.openHandler((Handler)con);
            unopenedConnection.open();
            return con;
        });
    }
}

