/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.sigfox.impl;

import com.google.common.io.BaseEncoding;
import io.opentracing.Span;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.HttpContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.usernamepassword.UsernamePasswordAuthProvider;
import org.eclipse.hono.adapter.auth.device.usernamepassword.UsernamePasswordCredentials;
import org.eclipse.hono.adapter.http.AbstractVertxBasedHttpProtocolAdapter;
import org.eclipse.hono.adapter.http.HonoBasicAuthHandler;
import org.eclipse.hono.adapter.sigfox.impl.SigfoxProtocolAdapterProperties;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SigfoxProtocolAdapter
extends AbstractVertxBasedHttpProtocolAdapter<SigfoxProtocolAdapterProperties> {
    private static final String DOWNLINK_DATA_FIELD = "downlinkData";
    private static final String SIGFOX_PROPERTY_PREFIX = "sigfox.";
    private static final String SIGFOX_PARAM_DEVICE_ID = "device";
    private static final String SIGFOX_PARAM_DATA = "data";
    private static final String SIGFOX_PARAM_TENANT = "tenant";
    private static final String SIGFOX_HEADER_PARAM_ACK = "ack";
    private static final String SIGFOX_QUERY_PARAM_ACK = "ack";
    private static final Logger LOG = LoggerFactory.getLogger(SigfoxProtocolAdapter.class);
    private DeviceCredentialsAuthProvider<UsernamePasswordCredentials> usernamePasswordAuthProvider;

    public void setUsernamePasswordAuthProvider(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> provider) {
        this.usernamePasswordAuthProvider = Objects.requireNonNull(provider);
    }

    public String getTypeName() {
        return "hono-sigfox";
    }

    private void setupAuthorization(Router router) {
        ChainAuthHandler authHandler = ChainAuthHandler.any();
        authHandler.add((AuthenticationHandler)new HonoBasicAuthHandler(Optional.ofNullable(this.usernamePasswordAuthProvider).orElseGet(() -> new UsernamePasswordAuthProvider(this.getCredentialsClient(), this.tracer)), ((SigfoxProtocolAdapterProperties)((Object)this.getConfig())).getRealm(), (x$0, x$1) -> this.handleBeforeCredentialsValidation(x$0, (HttpContext)x$1)));
        router.route().handler((Handler)authHandler);
    }

    protected void addRoutes(Router router) {
        this.setupAuthorization(router);
        router.route("/data/telemetry/:tenant").method(HttpMethod.GET).handler(this.dataCorsHandler()).handler((Handler)this.getBodyHandler()).handler(ctx -> this.dataHandler(HttpContext.from((RoutingContext)ctx), (x$0, x$1, x$2, x$3, x$4) -> this.uploadTelemetryMessage(x$0, x$1, x$2, x$3, x$4)));
        router.route("/data/event/:tenant").method(HttpMethod.GET).handler(this.dataCorsHandler()).handler((Handler)this.getBodyHandler()).handler(ctx -> this.dataHandler(HttpContext.from((RoutingContext)ctx), (x$0, x$1, x$2, x$3, x$4) -> this.uploadEventMessage(x$0, x$1, x$2, x$3, x$4)));
        router.errorHandler(500, t -> LOG.warn("Unhandled exception", t.failure()));
    }

    private Handler<RoutingContext> dataCorsHandler() {
        return CorsHandler.create().addOrigin(((SigfoxProtocolAdapterProperties)((Object)this.getConfig())).getCorsAllowedOrigin()).allowedMethod(HttpMethod.GET).allowedHeader("hono-ttd").allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).exposedHeader("hono-command").exposedHeader("hono-cmd-req-id");
    }

    private void dataHandler(HttpContext ctx, UploadHandler uploadHandler) {
        if (!ctx.isDeviceAuthenticated()) {
            LOG.warn("Not a device");
            return;
        }
        DeviceUser gatewayDevice = ctx.getAuthenticatedDevice();
        String deviceTenant = gatewayDevice.getTenantId();
        String requestTenant = ctx.getRoutingContext().pathParam(SIGFOX_PARAM_TENANT);
        String deviceId = ctx.getRoutingContext().queryParams().get(SIGFOX_PARAM_DEVICE_ID);
        String strData = ctx.getRoutingContext().queryParams().get(SIGFOX_PARAM_DATA);
        LOG.debug("{} handler - deviceTenant: {}, requestTenant: {}, deviceId: {}, data: {}", new Object[]{ctx.request().method(), deviceTenant, requestTenant, deviceId, strData});
        if (requestTenant == null) {
            ctx.fail((Throwable)new ClientErrorException(404, "missing the tenant information in the request URL"));
            return;
        }
        if (!requestTenant.equals(deviceTenant)) {
            ctx.fail((Throwable)new ClientErrorException(403, "tenant information mismatch"));
            return;
        }
        Buffer data = SigfoxProtocolAdapter.decodeData(strData);
        String contentType = Optional.ofNullable(data).map(d -> "application/octet-stream").orElse("application/vnd.eclipse-hono-empty-notification");
        uploadHandler.upload(ctx, deviceTenant, deviceId, data, contentType);
    }

    protected void customizeDownstreamMessageProperties(Map<String, Object> properties, HttpContext ctx) {
        super.customizeDownstreamMessageProperties(properties, ctx);
        for (Map.Entry entry : ctx.getRoutingContext().queryParams()) {
            if (entry.getKey() == null || !((String)entry.getKey()).startsWith(SIGFOX_PROPERTY_PREFIX)) continue;
            properties.put((String)entry.getKey(), entry.getValue());
        }
    }

    private static Buffer decodeData(String data) {
        if (data == null) {
            return null;
        }
        return Buffer.buffer((byte[])BaseEncoding.base16().decode((CharSequence)data.toUpperCase()));
    }

    protected Integer getTimeUntilDisconnectFromRequest(HttpContext ctx) {
        String ack = ctx.getRoutingContext().queryParams().get("ack");
        if (ack == null) {
            ack = ctx.request().getHeader("ack");
        }
        if (ack == null) {
            return null;
        }
        LOG.debug("Ack required for request?: '{}'", (Object)ack);
        if (!Boolean.parseBoolean(ack)) {
            return null;
        }
        return ((SigfoxProtocolAdapterProperties)((Object)this.getConfig())).getTtdWhenAckRequired();
    }

    protected boolean isCommandValid(Command command, Span span) {
        if (!super.isCommandValid(command, span)) {
            return false;
        }
        if (!command.isOneWay()) {
            TracingHelper.logError((Span)span, (String)"command must be one way");
            return false;
        }
        if (command.getPayload() == null) {
            TracingHelper.logError((Span)span, (String)"command has no payload");
            return false;
        }
        if (command.getPayloadSize() != 8) {
            TracingHelper.logError((Span)span, (String)("command payload size must be exactly 8 bytes long, is " + command.getPayloadSize()));
            return false;
        }
        return true;
    }

    protected void setEmptyResponsePayload(HttpServerResponse response, Span currentSpan) {
        LOG.debug("Setting empty response for ACK");
        response.setStatusCode(204);
        currentSpan.log("responding with: no content");
    }

    protected void setNonEmptyResponsePayload(HttpServerResponse response, CommandContext commandContext, Span currentSpan) {
        currentSpan.log("responding with: payload");
        Command command = commandContext.getCommand();
        response.setStatusCode(200);
        Buffer payload = this.convertToResponsePayload(command);
        LOG.debug("Setting response for ACK: {}", (Object)payload);
        HttpUtils.setResponseBody((HttpServerResponse)response, (Buffer)payload, (String)"application/json");
    }

    private Buffer convertToResponsePayload(Command command) {
        JsonObject payload = new JsonObject();
        payload.put(command.getGatewayOrDeviceId(), (Object)new JsonObject().put(DOWNLINK_DATA_FIELD, (Object)BaseEncoding.base16().encode(command.getPayload().getBytes()).toLowerCase()));
        return payload.toBuffer();
    }

    @FunctionalInterface
    private static interface UploadHandler {
        public void upload(HttpContext var1, String var2, String var3, Buffer var4, String var5);
    }
}

