/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.sigfox.app;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import org.eclipse.hono.adapter.ProtocolAdapterProperties;
import org.eclipse.hono.adapter.http.MicrometerBasedHttpAdapterMetrics;
import org.eclipse.hono.adapter.sigfox.impl.SigfoxProtocolAdapterOptions;
import org.eclipse.hono.adapter.sigfox.impl.SigfoxProtocolAdapterProperties;
import org.eclipse.hono.service.metric.MetricsTags;

@ApplicationScoped
public class MetricsFactory {
    @Singleton
    @Produces
    SigfoxProtocolAdapterProperties adapterProperties(SigfoxProtocolAdapterOptions adapterOptions) {
        if (!adapterOptions.httpAdapterOptions().adapterOptions().authenticationRequired()) {
            throw new IllegalStateException("SigFox Protocol Adapter does not support unauthenticated mode. Please change your configuration accordingly.");
        }
        return new SigfoxProtocolAdapterProperties(adapterOptions);
    }

    @Produces
    @Singleton
    MeterFilter commonTags() {
        return MeterFilter.commonTags((Iterable)MetricsTags.forProtocolAdapter((String)"hono-sigfox"));
    }

    @Singleton
    @Produces
    MicrometerBasedHttpAdapterMetrics metrics(Vertx vertx, MeterRegistry registry, SigfoxProtocolAdapterProperties adapterProperties) {
        return new MicrometerBasedHttpAdapterMetrics(registry, vertx, (ProtocolAdapterProperties)adapterProperties);
    }
}

