/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MappedMessage {
    private final String targetDeviceId;
    private final Buffer payload;
    private final Map<String, String> additionalProperties = new HashMap<String, String>();

    public MappedMessage(String targetDeviceId, Buffer payload) {
        this(targetDeviceId, payload, null);
    }

    public MappedMessage(String targetDeviceId, Buffer payload, Map<String, String> additionalProperties) {
        this.targetDeviceId = Objects.requireNonNull(targetDeviceId);
        this.payload = Optional.ofNullable(payload).orElseGet(Buffer::buffer);
        Optional.ofNullable(additionalProperties).ifPresent(props -> this.additionalProperties.putAll(additionalProperties));
    }

    public String getTargetDeviceId() {
        return this.targetDeviceId;
    }

    public Buffer getPayload() {
        return this.payload;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }
}

