/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.micrometer.core.instrument.Timer;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.messages.MqttPublishMessage;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.MapBasedTelemetryExecutionContext;
import org.eclipse.hono.adapter.mqtt.PropertyBag;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public final class MqttContext
extends MapBasedTelemetryExecutionContext {
    private static final String PARAM_ON_ERROR = "on-error";
    private final MqttPublishMessage message;
    private final MqttEndpoint deviceEndpoint;
    private final Device authenticatedDevice;
    private String contentType;
    private MetricsTags.EndpointType endpoint;
    private PropertyBag propertyBag;
    private Optional<Duration> timeToLive = Optional.empty();
    private ErrorHandlingMode errorHandlingMode = ErrorHandlingMode.DEFAULT;
    private ResourceIdentifier topic;
    private Buffer mappedPayload;
    private Timer.Sample timer;

    private MqttContext(MqttPublishMessage message, MqttEndpoint deviceEndpoint, Span span, Device authenticatedDevice) {
        super(span, authenticatedDevice);
        this.message = Objects.requireNonNull(message);
        this.deviceEndpoint = Objects.requireNonNull(deviceEndpoint);
        this.authenticatedDevice = authenticatedDevice;
    }

    public static MqttContext fromPublishPacket(MqttPublishMessage publishedMessage, MqttEndpoint deviceEndpoint, Span span) {
        return MqttContext.fromPublishPacket(publishedMessage, deviceEndpoint, span, null);
    }

    public static MqttContext fromPublishPacket(MqttPublishMessage publishedMessage, MqttEndpoint deviceEndpoint, Span span, Device authenticatedDevice) {
        Objects.requireNonNull(publishedMessage);
        Objects.requireNonNull(deviceEndpoint);
        Objects.requireNonNull(span);
        MqttContext result = new MqttContext(publishedMessage, deviceEndpoint, span, authenticatedDevice);
        Optional.ofNullable(publishedMessage.topicName()).map(PropertyBag::fromTopic).ifPresent(bag -> {
            result.propertyBag = bag;
            result.topic = bag.topicWithoutPropertyBag();
            result.endpoint = MetricsTags.EndpointType.fromString((String)result.topic.getEndpoint());
            result.contentType = bag.getProperty("content-type");
            if (result.endpoint == MetricsTags.EndpointType.EVENT) {
                result.timeToLive = MqttContext.determineTimeToLive(bag);
            }
            result.errorHandlingMode = ErrorHandlingMode.from(bag.getProperty(PARAM_ON_ERROR));
        });
        return result;
    }

    private static Optional<Duration> determineTimeToLive(PropertyBag properties) {
        try {
            Duration timeToLive = Optional.ofNullable(properties).map(propBag -> propBag.getProperty("hono-ttl")).map(Long::parseLong).map(ttl -> ttl < 0L ? null : Duration.ofSeconds(ttl)).orElse(null);
            return Optional.ofNullable(timeToLive);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public QoS getRequestedQos() {
        switch (this.message.qosLevel()) {
            case AT_LEAST_ONCE: {
                return QoS.AT_LEAST_ONCE;
            }
            case AT_MOST_ONCE: {
                return QoS.AT_MOST_ONCE;
            }
        }
        return null;
    }

    public MqttQoS qosLevel() {
        return this.message.qosLevel();
    }

    public boolean isRetain() {
        return this.message.isRetain();
    }

    public Buffer payload() {
        return Optional.ofNullable(this.mappedPayload).or(() -> Optional.ofNullable(this.message.payload())).orElseGet(Buffer::buffer);
    }

    public MqttEndpoint deviceEndpoint() {
        return this.deviceEndpoint;
    }

    public Device authenticatedDevice() {
        return this.authenticatedDevice;
    }

    public String contentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = Objects.requireNonNull(contentType);
    }

    public ResourceIdentifier topic() {
        return this.topic;
    }

    public void applyMappedTargetDeviceId(String mappedTargetDeviceId) {
        Objects.requireNonNull(mappedTargetDeviceId);
        if (this.topic != null && !mappedTargetDeviceId.equals(this.topic.getResourceId())) {
            this.topic = ResourceIdentifier.from((ResourceIdentifier)this.topic, (String)this.topic.getTenantId(), (String)mappedTargetDeviceId);
        }
    }

    public void applyMappedPayload(Buffer payload) {
        this.mappedPayload = Objects.requireNonNull(payload);
    }

    public String tenant() {
        if (this.authenticatedDevice != null) {
            return this.authenticatedDevice.getTenantId();
        }
        if (this.topic != null && !Strings.isNullOrEmpty((Object)this.topic.getTenantId())) {
            return this.topic.getTenantId();
        }
        return null;
    }

    public String deviceId() {
        if (this.topic != null && !Strings.isNullOrEmpty((Object)this.topic.getResourceId())) {
            return this.topic.getResourceId();
        }
        if (this.authenticatedDevice != null) {
            return this.authenticatedDevice.getDeviceId();
        }
        return null;
    }

    public String correlationId() {
        String propertyBagValue;
        if (this.propertyBag != null && (propertyBagValue = this.propertyBag.getProperty("correlation-id")) != null) {
            return propertyBagValue;
        }
        return this.isAtLeastOnce() ? Integer.toString(this.message.messageId()) : null;
    }

    public PropertyBag propertyBag() {
        return this.propertyBag;
    }

    public MetricsTags.EndpointType endpoint() {
        return this.endpoint;
    }

    public boolean isAtLeastOnce() {
        if (this.message == null) {
            return false;
        }
        return MqttQoS.AT_LEAST_ONCE == this.message.qosLevel();
    }

    public void acknowledge() {
        if (this.message != null && this.deviceEndpoint != null && this.isAtLeastOnce()) {
            this.deviceEndpoint.publishAcknowledge(this.message.messageId());
        }
    }

    public void setTimer(Timer.Sample timer) {
        this.timer = timer;
    }

    public Timer.Sample getTimer() {
        return this.timer;
    }

    public ErrorHandlingMode getErrorHandlingMode(boolean errorSubscriptionExists) {
        if (this.errorHandlingMode == ErrorHandlingMode.DEFAULT) {
            return errorSubscriptionExists ? ErrorHandlingMode.IGNORE : ErrorHandlingMode.DISCONNECT;
        }
        return this.errorHandlingMode;
    }

    public String getOrigAddress() {
        return this.message.topicName();
    }

    public Optional<Duration> getTimeToLive() {
        return this.timeToLive;
    }

    public static enum ErrorHandlingMode {
        DISCONNECT("disconnect"),
        IGNORE("ignore"),
        SKIP_ACK("skip-ack"),
        DEFAULT("default");

        private final String parameterValue;

        private ErrorHandlingMode(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public static ErrorHandlingMode from(String paramValue) {
            if (paramValue != null) {
                for (ErrorHandlingMode mode : ErrorHandlingMode.values()) {
                    if (!paramValue.equals(mode.parameterValue)) continue;
                    return mode;
                }
            }
            return DEFAULT;
        }
    }
}

