/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.hono.adapter.lora.SubscriptionKey;
import org.eclipse.hono.adapter.lora.providers.LoraProvider;
import org.eclipse.hono.client.command.ProtocolAdapterCommandConsumer;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.DeviceChangeNotification;
import org.eclipse.hono.notification.deviceregistry.LifecycleChange;
import org.eclipse.hono.notification.deviceregistry.TenantChangeNotification;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.TriTuple;

public class LoraCommandSubscriptions {
    private final Vertx vertx;
    private final Tracer tracer;
    private final Map<SubscriptionKey, TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context>> commandSubscriptions;

    public LoraCommandSubscriptions(Vertx vertx, Tracer tracer) {
        this.vertx = vertx;
        this.tracer = tracer;
        this.commandSubscriptions = new ConcurrentHashMap<SubscriptionKey, TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context>>();
    }

    public void init() {
        NotificationEventBusSupport.registerConsumer((Vertx)this.vertx, (NotificationType)TenantChangeNotification.TYPE, notification -> {
            if (LifecycleChange.DELETE.equals((Object)notification.getChange()) || LifecycleChange.UPDATE.equals((Object)notification.getChange()) && !notification.isTenantEnabled()) {
                this.closeConsumersForTenant(notification.getTenantId());
            }
        });
        NotificationEventBusSupport.registerConsumer((Vertx)this.vertx, (NotificationType)DeviceChangeNotification.TYPE, notification -> {
            if (LifecycleChange.DELETE.equals((Object)notification.getChange())) {
                this.closeConsumersForGateway(notification.getTenantId(), notification.getDeviceId());
            }
        });
    }

    private void closeConsumersForGateway(String tenantId, String gatewayId) {
        SubscriptionKey key = new SubscriptionKey(tenantId, gatewayId);
        TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context> subscription = this.commandSubscriptions.remove(key);
        if (subscription == null) {
            return;
        }
        this.tracer.activateSpan(null);
        Context currentCtx = this.vertx.getOrCreateContext();
        Span span = TracingHelper.buildSpan((Tracer)this.tracer, null, (String)"close command subscription for deleted gateway", (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").start();
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)gatewayId);
        Context subscriptionContext = (Context)subscription.three();
        subscriptionContext.runOnContext(x -> {
            ProtocolAdapterCommandConsumer commandConsumer = (ProtocolAdapterCommandConsumer)subscription.one();
            commandConsumer.close(false, span.context()).onComplete(r -> currentCtx.runOnContext(s -> span.finish()));
        });
    }

    private void closeConsumersForTenant(String tenantId) {
        if (!this.commandSubscriptions.entrySet().stream().anyMatch(e -> ((SubscriptionKey)e.getKey()).getTenant().equals(tenantId))) {
            return;
        }
        this.tracer.activateSpan(null);
        Context currentCtx = this.vertx.getOrCreateContext();
        Span span = TracingHelper.buildSpan((Tracer)this.tracer, null, (String)"close command subscriptions for disabled/deleted tenant", (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").start();
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, null);
        List<Future> consumerCloseFutures = Collections.synchronizedList(new ArrayList());
        Iterator<Map.Entry<SubscriptionKey, TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context>>> iter = this.commandSubscriptions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<SubscriptionKey, TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context>> subscription = iter.next();
            if (!subscription.getKey().getTenant().equals(tenantId)) continue;
            Promise closePromise = Promise.promise();
            consumerCloseFutures.add(closePromise.future());
            Context subscriptionContext = (Context)subscription.getValue().three();
            subscriptionContext.runOnContext(x -> {
                ProtocolAdapterCommandConsumer commandConsumer = (ProtocolAdapterCommandConsumer)((TriTuple)subscription.getValue()).one();
                commandConsumer.close(false, span.context()).onComplete((Handler)closePromise);
            });
            iter.remove();
        }
        Future.join(consumerCloseFutures).onComplete(x -> currentCtx.runOnContext(s -> span.finish()));
    }

    public boolean contains(SubscriptionKey key) {
        return this.commandSubscriptions.containsKey(key);
    }

    public TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context> getSubscription(SubscriptionKey key) {
        return this.commandSubscriptions.get(key);
    }

    public TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context> add(SubscriptionKey key, ProtocolAdapterCommandConsumer consumer, LoraProvider loraProvider, Context ctx) {
        return this.commandSubscriptions.put(key, (TriTuple<ProtocolAdapterCommandConsumer, LoraProvider, Context>)TriTuple.of((Object)consumer, (Object)loraProvider, (Object)ctx));
    }
}

