/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.JsonBasedLoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

@ApplicationScoped
public class MultiTechProvider
extends JsonBasedLoraProvider {
    private static final String FIELD_MULTITECH_ADR = "adr";
    private static final String FIELD_MULTITECH_CHANNEL = "chan";
    private static final String FIELD_MULTITECH_CODE_RATE = "codr";
    private static final String FIELD_MULTITECH_DATA_RATE = "datr";
    private static final String FIELD_MULTITECH_DEVICE = "deveui";
    private static final String FIELD_MULTITECH_FRAME_COUNT = "fcnt";
    private static final String FIELD_MULTITECH_FREQUENCY = "freq";
    private static final String FIELD_MULTITECH_FUNCTION_PORT = "port";
    private static final String FIELD_MULTITECH_GATEWAY_ID = "gweui";
    private static final String FIELD_MULTITECH_LSNR = "lsnr";
    private static final String FIELD_MULTITECH_PAYLOAD = "data";
    private static final String FIELD_MULTITECH_RSSI = "rssi";
    private static final String MULTITECH_BANDWIDTH = "BW";
    private static final String MULTITECH_SPREADING_FACTOR = "SF";

    @Override
    public String getProviderName() {
        return "multiTech";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/multitech");
    }

    @Override
    protected byte[] getDevEui(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_DEVICE, String.class).map(s -> this.multiTechEuiToHex((String)s)).map(LoraUtils::convertFromHexToBytes).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain device ID property"));
    }

    private String multiTechEuiToHex(String s) {
        return s.replace("-", "");
    }

    @Override
    protected Buffer getPayload(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_PAYLOAD, String.class).map(s -> Buffer.buffer((byte[])Base64.getDecoder().decode((String)s))).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain Base64 encoded payload property"));
    }

    @Override
    protected LoraMessageType getMessageType(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        if (loraMessage.containsKey(FIELD_MULTITECH_PAYLOAD)) {
            return LoraMessageType.UPLINK;
        }
        return LoraMessageType.UNKNOWN;
    }

    @Override
    protected LoraMetaData getMetaData(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        LoraMetaData data = new LoraMetaData();
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_FUNCTION_PORT, Integer.class).ifPresent(data::setFunctionPort);
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_FRAME_COUNT, Integer.class).ifPresent(data::setFrameCount);
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_ADR, Boolean.class).ifPresent(data::setAdaptiveDataRateEnabled);
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_FREQUENCY, Double.class).ifPresent(v -> data.setFrequency((Double)v));
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_DATA_RATE, String.class).ifPresent(datr -> {
            String[] dataRateParts = datr.split(MULTITECH_BANDWIDTH, 2);
            String spreadingFactor = dataRateParts[0].replace(MULTITECH_SPREADING_FACTOR, "");
            String bandWith = dataRateParts[1];
            data.setSpreadingFactor(Integer.parseInt(spreadingFactor));
            data.setBandwidth(Integer.parseInt(bandWith));
        });
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_CODE_RATE, String.class).ifPresent(data::setCodingRate);
        GatewayInfo gateway = new GatewayInfo();
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_GATEWAY_ID, String.class).ifPresent(v -> gateway.setGatewayId(this.multiTechEuiToHex((String)v)));
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_RSSI, Integer.class).ifPresent(gateway::setRssi);
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_LSNR, Double.class).ifPresent(gateway::setSnr);
        LoraUtils.getChildObject(loraMessage, FIELD_MULTITECH_CHANNEL, Integer.class).ifPresent(gateway::setChannel);
        data.addGatewayInfo(gateway);
        return data;
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return Map.of(HttpHeaders.CONTENT_TYPE.toString(), "application/json", HttpHeaders.ACCEPT.toString(), "application/json");
    }
}

