/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.JsonBasedLoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

@ApplicationScoped
public class ChirpStackProvider
extends JsonBasedLoraProvider {
    private static final String FIELD_CHIRPSTACK_ADR = "adr";
    private static final String FIELD_CHIRPSTACK_ALTITUDE = "altitude";
    private static final String FIELD_CHIRPSTACK_BANDWIDTH = "bandwidth";
    private static final String FIELD_CHIRPSTACK_CHANNEL = "channel";
    private static final String FIELD_CHIRPSTACK_CODE_RATE = "codeRate";
    private static final String FIELD_CHIRPSTACK_DEVICE = "devEUI";
    private static final String FIELD_CHIRPSTACK_FRAME_COUNT = "fCnt";
    private static final String FIELD_CHIRPSTACK_FREQUENCY = "frequency";
    private static final String FIELD_CHIRPSTACK_FUNCTION_PORT = "fPort";
    private static final String FIELD_CHIRPSTACK_GATEWAY_ID = "gatewayID";
    private static final String FIELD_CHIRPSTACK_LATITUDE = "latitude";
    private static final String FIELD_CHIRPSTACK_LOCATION = "location";
    private static final String FIELD_CHIRPSTACK_LONGITUDE = "longitude";
    private static final String FIELD_CHIRPSTACK_LORA_MODULATION_INFO = "loRaModulationInfo";
    private static final String FIELD_CHIRPSTACK_LSNR = "loRaSNR";
    private static final String FIELD_CHIRPSTACK_PAYLOAD = "data";
    private static final String FIELD_CHIRPSTACK_RSSI = "rssi";
    private static final String FIELD_CHIRPSTACK_RX_INFO = "rxInfo";
    private static final String FIELD_CHIRPSTACK_SPREADING_FACTOR = "spreadingFactor";
    private static final String FIELD_CHIRPSTACK_TX_INFO = "txInfo";
    private static final String COMMAND_FIELD_CHIRPSTACK_CONFIRMED = "confirmed";
    private static final String COMMAND_FIELD_CHIRPSTACK_DATA = "data";
    private static final String COMMAND_FIELD_CHIRPSTACK_DEVICE_QUEUE_ITEM = "deviceQueueItem";
    private static final String COMMAND_FIELD_CHIRPSTACK_PORT = "fPort";

    @Override
    public String getProviderName() {
        return "chirpStack";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/chirpstack");
    }

    @Override
    protected byte[] getDevEui(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, FIELD_CHIRPSTACK_DEVICE, String.class).map(s -> LoraUtils.convertFromBase64ToBytes(s)).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain Base64 encoded device ID property"));
    }

    @Override
    protected Buffer getPayload(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, "data", String.class).map(s -> Buffer.buffer((byte[])Base64.getDecoder().decode((String)s))).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain Base64 encoded payload property"));
    }

    @Override
    protected LoraMessageType getMessageType(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        if (loraMessage.containsKey("data")) {
            return LoraMessageType.UPLINK;
        }
        return LoraMessageType.UNKNOWN;
    }

    @Override
    protected LoraMetaData getMetaData(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        LoraMetaData data = new LoraMetaData();
        LoraUtils.getChildObject(loraMessage, "fPort", Integer.class).ifPresent(data::setFunctionPort);
        LoraUtils.getChildObject(loraMessage, FIELD_CHIRPSTACK_FRAME_COUNT, Integer.class).ifPresent(data::setFrameCount);
        LoraUtils.getChildObject(loraMessage, FIELD_CHIRPSTACK_ADR, Boolean.class).ifPresent(data::setAdaptiveDataRateEnabled);
        LoraUtils.getChildObject(loraMessage, FIELD_CHIRPSTACK_TX_INFO, JsonObject.class).map(txInfo -> {
            LoraUtils.getChildObject(txInfo, FIELD_CHIRPSTACK_FREQUENCY, Integer.class).ifPresent(v -> data.setFrequency(v.doubleValue() / 1000000.0));
            return txInfo.getValue(FIELD_CHIRPSTACK_LORA_MODULATION_INFO);
        }).filter(JsonObject.class::isInstance).map(JsonObject.class::cast).ifPresent(modulationInfo -> {
            LoraUtils.getChildObject(modulationInfo, FIELD_CHIRPSTACK_SPREADING_FACTOR, Integer.class).ifPresent(data::setSpreadingFactor);
            LoraUtils.getChildObject(modulationInfo, FIELD_CHIRPSTACK_BANDWIDTH, Integer.class).ifPresent(data::setBandwidth);
            LoraUtils.getChildObject(modulationInfo, FIELD_CHIRPSTACK_CODE_RATE, String.class).ifPresent(data::setCodingRate);
        });
        LoraUtils.getChildObject(loraMessage, FIELD_CHIRPSTACK_RX_INFO, JsonArray.class).ifPresent(rxInfoList -> rxInfoList.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(rxInfo -> {
            GatewayInfo gateway = new GatewayInfo();
            LoraUtils.getChildObject(rxInfo, FIELD_CHIRPSTACK_GATEWAY_ID, String.class).ifPresent(v -> gateway.setGatewayId(LoraUtils.convertFromBase64ToHex(v)));
            LoraUtils.getChildObject(rxInfo, FIELD_CHIRPSTACK_RSSI, Integer.class).ifPresent(gateway::setRssi);
            LoraUtils.getChildObject(rxInfo, FIELD_CHIRPSTACK_LSNR, Double.class).ifPresent(gateway::setSnr);
            LoraUtils.getChildObject(rxInfo, FIELD_CHIRPSTACK_CHANNEL, Integer.class).ifPresent(gateway::setChannel);
            LoraUtils.getChildObject(rxInfo, FIELD_CHIRPSTACK_LOCATION, JsonObject.class).map(loc -> LoraUtils.newLocation(LoraUtils.getChildObject(loc, FIELD_CHIRPSTACK_LONGITUDE, Double.class), LoraUtils.getChildObject(loc, FIELD_CHIRPSTACK_LATITUDE, Double.class), LoraUtils.getChildObject(loc, FIELD_CHIRPSTACK_ALTITUDE, Double.class))).ifPresent(gateway::setLocation);
            data.addGatewayInfo(gateway);
        }));
        return data;
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return Map.of(HttpHeaders.CONTENT_TYPE.toString(), "application/json", HttpHeaders.ACCEPT.toString(), "application/json");
    }

    @Override
    protected JsonObject getCommandPayload(Buffer payload, String deviceId, String subject) {
        JsonObject deviceQueueItem = new JsonObject();
        deviceQueueItem.put(COMMAND_FIELD_CHIRPSTACK_CONFIRMED, (Object)false);
        deviceQueueItem.put("data", (Object)payload.getBytes());
        try {
            deviceQueueItem.put("fPort", (Object)Integer.parseInt(subject));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JsonObject json = new JsonObject();
        json.put(COMMAND_FIELD_CHIRPSTACK_DEVICE_QUEUE_ITEM, (Object)deviceQueueItem);
        return json;
    }
}

