/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.HttpContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.usernamepassword.UsernamePasswordAuthProvider;
import org.eclipse.hono.adapter.auth.device.usernamepassword.UsernamePasswordCredentials;
import org.eclipse.hono.adapter.auth.device.x509.SubjectDnCredentials;
import org.eclipse.hono.adapter.auth.device.x509.TenantServiceBasedX509Authentication;
import org.eclipse.hono.adapter.auth.device.x509.X509AuthProvider;
import org.eclipse.hono.adapter.auth.device.x509.X509Authentication;
import org.eclipse.hono.adapter.http.AbstractVertxBasedHttpProtocolAdapter;
import org.eclipse.hono.adapter.http.HonoBasicAuthHandler;
import org.eclipse.hono.adapter.http.HttpProtocolAdapterProperties;
import org.eclipse.hono.adapter.http.X509AuthHandler;
import org.eclipse.hono.adapter.lora.LoraCommand;
import org.eclipse.hono.adapter.lora.LoraCommandSubscriptions;
import org.eclipse.hono.adapter.lora.LoraMessage;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.SubscriptionKey;
import org.eclipse.hono.adapter.lora.UplinkLoraMessage;
import org.eclipse.hono.adapter.lora.providers.LoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.ProtocolAdapterCommandConsumer;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.http.HttpServerSpanHelper;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CommandEndpoint;
import org.eclipse.hono.util.TenantObject;
import org.eclipse.hono.util.TriTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoraProtocolAdapter
extends AbstractVertxBasedHttpProtocolAdapter<HttpProtocolAdapterProperties> {
    static final String SPAN_NAME_PROCESS_MESSAGE = "process message";
    private static final Logger LOG = LoggerFactory.getLogger(LoraProtocolAdapter.class);
    private static final String ERROR_MSG_MISSING_OR_UNSUPPORTED_CONTENT_TYPE = "missing or unsupported content-type";
    private static final String ERROR_MSG_INVALID_PAYLOAD = "invalid payload";
    private static final Tag<String> TAG_LORA_DEVICE_ID = new StringTag("lora_device_id");
    private static final Tag<String> TAG_LORA_PROVIDER = new StringTag("lora_provider");
    private final List<LoraProvider> loraProviders = new ArrayList<LoraProvider>();
    private final WebClient webClient;
    private DeviceCredentialsAuthProvider<UsernamePasswordCredentials> usernamePasswordAuthProvider;
    private DeviceCredentialsAuthProvider<SubjectDnCredentials> clientCertAuthProvider;
    private LoraCommandSubscriptions commandSubscriptions;

    public LoraProtocolAdapter(WebClient webClient) {
        this.webClient = Objects.requireNonNull(webClient);
    }

    public void setLoraProviders(List<LoraProvider> providers) {
        Objects.requireNonNull(providers);
        this.loraProviders.clear();
        this.loraProviders.addAll(providers);
    }

    public void setUsernamePasswordAuthProvider(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> provider) {
        this.usernamePasswordAuthProvider = Objects.requireNonNull(provider);
    }

    public void setClientCertAuthProvider(DeviceCredentialsAuthProvider<SubjectDnCredentials> provider) {
        this.clientCertAuthProvider = Objects.requireNonNull(provider);
    }

    public void setCommandSubscriptions(LoraCommandSubscriptions commandSubscriptions) {
        this.commandSubscriptions = commandSubscriptions;
    }

    public String getTypeName() {
        return "hono-lora";
    }

    protected void addRoutes(Router router) {
        ChainAuthHandler authHandler = ChainAuthHandler.any();
        authHandler.add((AuthenticationHandler)new X509AuthHandler((X509Authentication)new TenantServiceBasedX509Authentication(this.getTenantClient(), this.tracer), Optional.ofNullable(this.clientCertAuthProvider).orElseGet(() -> new X509AuthProvider(this.getCredentialsClient(), this.tracer)), (x$0, x$1) -> this.handleBeforeCredentialsValidation(x$0, (HttpContext)x$1)));
        authHandler.add((AuthenticationHandler)new HonoBasicAuthHandler(Optional.ofNullable(this.usernamePasswordAuthProvider).orElseGet(() -> new UsernamePasswordAuthProvider(this.getCredentialsClient(), this.tracer)), ((HttpProtocolAdapterProperties)this.getConfig()).getRealm(), (x$0, x$1) -> this.handleBeforeCredentialsValidation(x$0, (HttpContext)x$1)));
        for (LoraProvider provider : this.loraProviders) {
            for (String pathPrefix : provider.pathPrefixes()) {
                router.route(HttpMethod.OPTIONS, pathPrefix).handler((Handler)authHandler).handler(this::handleOptionsRoute);
                router.route(provider.acceptedHttpMethod(), pathPrefix).consumes(provider.acceptedContentType()).handler((Handler)authHandler).handler((Handler)this.getBodyHandler()).handler(ctx -> this.handleProviderRoute(HttpContext.from((RoutingContext)ctx), provider));
                router.route(provider.acceptedHttpMethod(), pathPrefix).handler((Handler)authHandler).handler(ctx -> {
                    LOG.debug("request does not contain content-type header, will return 400 ...");
                    this.handle400((RoutingContext)ctx, ERROR_MSG_MISSING_OR_UNSUPPORTED_CONTENT_TYPE);
                });
            }
        }
    }

    protected void customizeDownstreamMessageProperties(Map<String, Object> properties, HttpContext ctx) {
        properties.put("orig_lora_provider", ctx.get("orig_lora_provider"));
        Optional.ofNullable(ctx.get("meta_data")).map(LoraMetaData.class::cast).ifPresent(metaData -> {
            Optional.ofNullable(metaData.getFunctionPort()).ifPresent(port -> properties.put("function_port", port));
            String json = Json.encode((Object)metaData);
            properties.put("meta_data", json);
        });
        Optional.ofNullable(ctx.get("additional_data")).map(JsonObject.class::cast).ifPresent(data -> properties.put("additional_data", data.encode()));
    }

    void handleProviderRoute(HttpContext ctx, LoraProvider provider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing request from provider [name: {}, URI: {}]", (Object)provider.getProviderName(), (Object)ctx.getRoutingContext().normalizedPath());
        }
        Span currentSpan = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)ctx.getTracingContext(), (String)SPAN_NAME_PROCESS_MESSAGE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        TAG_LORA_PROVIDER.set(currentSpan, (Object)provider.getProviderName());
        ctx.put("orig_lora_provider", (Object)provider.getProviderName());
        if (!ctx.isDeviceAuthenticated()) {
            this.logUnsupportedUserType(ctx.getRoutingContext(), currentSpan);
            currentSpan.finish();
            this.handle401(ctx.getRoutingContext());
            return;
        }
        DeviceUser gatewayDevice = ctx.getAuthenticatedDevice();
        TracingHelper.setDeviceTags((Span)currentSpan, (String)gatewayDevice.getTenantId(), (String)gatewayDevice.getDeviceId());
        try {
            LoraMessage loraMessage = provider.getMessage(ctx.getRoutingContext());
            LoraMessageType type = loraMessage.getType();
            currentSpan.log(Map.of("message type", type));
            String deviceId = loraMessage.getDevEUIAsString();
            currentSpan.setTag(TAG_LORA_DEVICE_ID, (Object)deviceId);
            switch (type) {
                case UPLINK: {
                    UplinkLoraMessage uplinkMessage = (UplinkLoraMessage)loraMessage;
                    Buffer payload = uplinkMessage.getPayload();
                    Optional.ofNullable(uplinkMessage.getMetaData()).ifPresent(metaData -> ctx.put("meta_data", metaData));
                    Optional.ofNullable(uplinkMessage.getAdditionalData()).ifPresent(additionalData -> ctx.put("additional_data", additionalData));
                    String contentType = payload.length() > 0 ? "application/vnd.eclipse-hono.lora." + provider.getProviderName() : "application/vnd.eclipse-hono-empty-notification";
                    currentSpan.finish();
                    this.uploadTelemetryMessage(ctx, gatewayDevice.getTenantId(), deviceId, payload, contentType);
                    this.registerCommandConsumerIfNeeded(provider, (Device)gatewayDevice, currentSpan.context());
                    break;
                }
                default: {
                    LOG.debug("discarding message of unsupported type [tenant: {}, device-id: {}, type: {}]", new Object[]{gatewayDevice.getTenantId(), deviceId, type});
                    currentSpan.log("discarding message of unsupported type");
                    currentSpan.finish();
                    this.handle202(ctx.getRoutingContext());
                    break;
                }
            }
        }
        catch (LoraProviderMalformedPayloadException e) {
            LOG.debug("error processing request from provider [name: {}]", (Object)provider.getProviderName(), (Object)e);
            TracingHelper.logError((Span)currentSpan, (String)"error processing request", (Throwable)e);
            currentSpan.finish();
            this.handle400(ctx.getRoutingContext(), ERROR_MSG_INVALID_PAYLOAD);
        }
    }

    private void registerCommandConsumerIfNeeded(LoraProvider provider, Device gatewayDevice, SpanContext context) {
        String gatewayId;
        String tenantId = gatewayDevice.getTenantId();
        SubscriptionKey key = new SubscriptionKey(tenantId, gatewayId = gatewayDevice.getDeviceId());
        if (this.commandSubscriptions.contains(key)) {
            return;
        }
        Span currentSpan = TracingHelper.buildFollowsFromSpan((Tracer)this.tracer, (SpanContext)context, (String)"create command consumer").withTag(Tags.SPAN_KIND.getKey(), "client").start();
        TracingHelper.setDeviceTags((Span)currentSpan, (String)tenantId, (String)gatewayId);
        TAG_LORA_PROVIDER.set(currentSpan, (Object)provider.getProviderName());
        this.getRegistrationClient().assertRegistration(tenantId, gatewayId, null, currentSpan.context()).onFailure(thr -> {
            LOG.debug("error asserting gateway registration, no command consumer will be created [tenant: {}, gateway-id: {}]", (Object)tenantId, (Object)gatewayId);
            TracingHelper.logError((Span)currentSpan, (String)"error asserting gateway registration, no command consumer will be created", (Throwable)thr);
        }).compose(assertion -> {
            if (assertion.getCommandEndpoint() == null) {
                LOG.debug("gateway has no command endpoint defined, skipping command consumer creation [tenant: {}, gateway-id: {}]", (Object)tenantId, (Object)gatewayId);
                currentSpan.log("gateway has no command endpoint defined, skipping command consumer creation");
                return Future.succeededFuture((Object)null);
            }
            return this.getCommandConsumerFactory().createCommandConsumer(tenantId, gatewayId, false, this::handleCommand, null, currentSpan.context()).onFailure(thr -> TracingHelper.logError((Span)currentSpan, (Throwable)thr)).map(commandConsumer -> this.commandSubscriptions.add(key, (ProtocolAdapterCommandConsumer)commandConsumer, provider, this.vertx.getOrCreateContext())).mapEmpty();
        }).onComplete(ar -> currentSpan.finish());
    }

    private Future<Void> handleCommand(CommandContext commandContext) {
        String gatewayId;
        Tags.COMPONENT.set(commandContext.getTracingSpan(), this.getTypeName());
        Timer.Sample timer = this.getMetrics().startTimer();
        Command command = commandContext.getCommand();
        if (command.getGatewayId() == null) {
            String errorMsg = "no gateway defined for command";
            LOG.debug("{} [{}]", (Object)"no gateway defined for command", (Object)command);
            ServerErrorException exception = new ServerErrorException(503, "no gateway defined for command");
            commandContext.release((Throwable)exception);
            return Future.failedFuture((Throwable)exception);
        }
        String tenant = command.getTenant();
        LoraProvider loraProvider = Optional.ofNullable(this.commandSubscriptions.getSubscription(new SubscriptionKey(tenant, gatewayId = command.getGatewayId()))).map(TriTuple::two).orElse(null);
        if (loraProvider == null) {
            LOG.debug("received command for unknown gateway [{}] for tenant [{}]", (Object)gatewayId, (Object)tenant);
            TracingHelper.logError((Span)commandContext.getTracingSpan(), (String)String.format("received command for unknown gateway [%s]", gatewayId));
            ServerErrorException exception = new ServerErrorException(503, "received command for unknown gateway");
            commandContext.release((Throwable)exception);
            return Future.failedFuture((Throwable)exception);
        }
        Future tenantTracker = this.getTenantConfiguration(tenant, commandContext.getTracingContext());
        return tenantTracker.compose(tenantObject -> {
            if (command.isValid()) {
                return this.checkMessageLimit((TenantObject)tenantObject, command.getPayloadSize(), commandContext.getTracingContext());
            }
            return Future.failedFuture((Throwable)new ClientErrorException(400, "malformed command message"));
        }).compose(success -> this.getRegistrationClient().assertRegistration(tenant, gatewayId, null, commandContext.getTracingContext())).compose(registrationAssertion -> this.sendCommandToGateway(commandContext, loraProvider, registrationAssertion.getCommandEndpoint())).onSuccess(aVoid -> {
            LoraProtocolAdapter.addMicrometerSample((CommandContext)commandContext, (Timer.Sample)timer);
            commandContext.accept();
            this.getMetrics().reportCommand(command.isOneWay() ? MetricsTags.Direction.ONE_WAY : MetricsTags.Direction.REQUEST, tenant, (TenantObject)tenantTracker.result(), MetricsTags.ProcessingOutcome.FORWARDED, command.getPayloadSize(), timer);
        }).onFailure(t -> {
            LOG.debug("error sending command", t);
            commandContext.release(t);
            this.getMetrics().reportCommand(command.isOneWay() ? MetricsTags.Direction.ONE_WAY : MetricsTags.Direction.REQUEST, tenant, (TenantObject)tenantTracker.result(), MetricsTags.ProcessingOutcome.from((Throwable)t), command.getPayloadSize(), timer);
        });
    }

    private Future<Void> sendCommandToGateway(CommandContext commandContext, LoraProvider loraProvider, CommandEndpoint commandEndpoint) {
        if (commandEndpoint == null) {
            return Future.failedFuture((String)"gateway has no command endpoint defined");
        }
        if (!commandEndpoint.isUriValid()) {
            return Future.failedFuture((String)String.format("gateway has command endpoint with invalid uri [%s]", commandEndpoint.getUri()));
        }
        Command command = commandContext.getCommand();
        Promise sendPromise = Promise.promise();
        Buffer payload = Optional.ofNullable(command.getPayload()).orElseGet(Buffer::buffer);
        String subject = command.getName();
        LoraCommand loraCommand = loraProvider.getCommand(commandEndpoint, command.getDeviceId(), payload, subject);
        commandContext.getTracingSpan().log(String.format("sending loraCommand to LNS [%s]", loraCommand.getUri()));
        LOG.debug("sending loraCommand to LNS [{}]", (Object)loraCommand.getUri());
        if (LOG.isTraceEnabled()) {
            LOG.trace("command payload:{}{}", (Object)System.lineSeparator(), (Object)loraCommand.getPayload().encodePrettily());
        }
        HttpRequest request = this.webClient.postAbs(loraCommand.getUri());
        commandEndpoint.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequest)request).putHeader(arg_0, arg_1));
        loraProvider.getDefaultHeaders().forEach((arg_0, arg_1) -> ((HttpRequest)request).putHeader(arg_0, arg_1));
        request.sendJson((Object)loraCommand.getPayload()).onFailure(arg_0 -> ((Promise)sendPromise).tryFail(arg_0)).onSuccess(httpClientResponse -> {
            Tags.HTTP_STATUS.set(commandContext.getTracingSpan(), Integer.valueOf(httpClientResponse.statusCode()));
            if (StatusCodeMapper.isSuccessful((Integer)httpClientResponse.statusCode())) {
                sendPromise.tryComplete();
            } else {
                sendPromise.tryFail(httpClientResponse.statusMessage());
            }
        });
        return sendPromise.future();
    }

    void handleOptionsRoute(RoutingContext ctx) {
        Span currentSpan = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)HttpServerSpanHelper.serverSpanContext((RoutingContext)ctx), (String)"process OPTIONS request", (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (ctx.user() instanceof Device) {
            currentSpan.finish();
            this.handle200(ctx);
        } else {
            this.logUnsupportedUserType(ctx, currentSpan);
            currentSpan.finish();
            this.handle401(ctx);
        }
    }

    private void logUnsupportedUserType(RoutingContext ctx, Span currentSpan) {
        String userType = Optional.ofNullable(ctx.user()).map(user -> user.getClass().getName()).orElse("null");
        TracingHelper.logError((Span)currentSpan, Map.of("message", "request contains unsupported type of user credentials", "type", userType));
        LOG.debug("request contains unsupported type of credentials [{}], returning 401", (Object)userType);
    }

    private void handle200(RoutingContext ctx) {
        ctx.response().setStatusCode(200);
        ctx.response().end();
    }

    private void handle202(RoutingContext ctx) {
        ctx.response().setStatusCode(202);
        ctx.response().end();
    }

    private void handle401(RoutingContext ctx) {
        HttpUtils.unauthorized((RoutingContext)ctx, (String)("Basic realm=\"" + ((HttpProtocolAdapterProperties)this.getConfig()).getRealm() + "\""));
    }

    private void handle400(RoutingContext ctx, String msg) {
        HttpUtils.badRequest((RoutingContext)ctx, (String)msg);
    }
}

