/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.hono.adapter.HttpContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.SubjectDnCredentials;
import org.eclipse.hono.adapter.auth.device.X509Authentication;
import org.eclipse.hono.adapter.http.AuthHandlerTools;
import org.eclipse.hono.service.auth.SniExtensionHelper;
import org.eclipse.hono.service.http.HttpServerSpanHelper;
import org.eclipse.hono.util.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509AuthHandler
extends AuthenticationHandlerImpl<DeviceCredentialsAuthProvider<SubjectDnCredentials>> {
    private static final Logger LOG = LoggerFactory.getLogger(X509AuthHandler.class);
    private static final HttpException UNAUTHORIZED = new HttpException(401);
    private final X509Authentication auth;
    private final PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler;

    public X509AuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider) {
        this(clientAuth, authProvider, null);
    }

    public X509AuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider, PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler) {
        super(authProvider);
        this.auth = Objects.requireNonNull(clientAuth);
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
    }

    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(handler);
        if (context.request().isSSL()) {
            try {
                this.auth.validateClientCertificate(context.request().sslSession().getPeerCertificates(), SniExtensionHelper.getHostNames((SSLSession)context.request().sslSession()), HttpServerSpanHelper.serverSpanContext((RoutingContext)context)).compose(credentialsJson -> {
                    ExecutionContextAuthHandler<HttpContext> authHandler = new ExecutionContextAuthHandler<HttpContext>((DeviceCredentialsAuthProvider)this.authProvider, this.preCredentialsValidationHandler){

                        public Future<JsonObject> parseCredentials(HttpContext context) {
                            return Future.succeededFuture((Object)credentialsJson);
                        }
                    };
                    return authHandler.authenticateDevice((ExecutionContext)HttpContext.from((RoutingContext)context)).map(User.class::cast);
                }).onComplete(handler);
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.debug("could not retrieve client certificate from request: {}", (Object)e.getMessage());
                handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
            }
        } else {
            handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
        }
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (ctx.response().ended()) {
            return;
        }
        AuthHandlerTools.processException(ctx, exception, null);
    }
}

