/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap.app;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Set;
import org.eclipse.hono.adapter.AbstractProtocolAdapterApplication;
import org.eclipse.hono.adapter.coap.CoapAdapterMetrics;
import org.eclipse.hono.adapter.coap.CoapAdapterProperties;
import org.eclipse.hono.adapter.coap.CommandResponseResource;
import org.eclipse.hono.adapter.coap.DeviceRegistryBasedCertificateVerifier;
import org.eclipse.hono.adapter.coap.DeviceRegistryBasedPskStore;
import org.eclipse.hono.adapter.coap.EventResource;
import org.eclipse.hono.adapter.coap.TelemetryResource;
import org.eclipse.hono.adapter.coap.impl.ConfigBasedCoapEndpointFactory;
import org.eclipse.hono.adapter.coap.impl.VertxBasedCoapAdapter;

@ApplicationScoped
public class Application
extends AbstractProtocolAdapterApplication<CoapAdapterProperties> {
    private static final String CONTAINER_ID = "Hono CoAP Adapter";
    @Inject
    CoapAdapterMetrics metrics;

    public String getComponentName() {
        return CONTAINER_ID;
    }

    protected VertxBasedCoapAdapter adapter() {
        VertxBasedCoapAdapter adapter = new VertxBasedCoapAdapter();
        adapter.setConfig((Object)((CoapAdapterProperties)this.protocolAdapterProperties));
        adapter.setMetrics(this.metrics);
        this.setCollaborators(adapter);
        adapter.addResources(Set.of(new TelemetryResource("telemetry", adapter, this.tracer, this.vertx), new TelemetryResource("t", adapter, this.tracer, this.vertx), new EventResource("event", adapter, this.tracer, this.vertx), new EventResource("e", adapter, this.tracer, this.vertx), new CommandResponseResource("command_response", adapter, this.tracer, this.vertx), new CommandResponseResource("cr", adapter, this.tracer, this.vertx)));
        ConfigBasedCoapEndpointFactory endpointFactory = new ConfigBasedCoapEndpointFactory(this.vertx, (CoapAdapterProperties)this.protocolAdapterProperties);
        endpointFactory.setPskStore(new DeviceRegistryBasedPskStore(adapter, this.tracer));
        endpointFactory.setCertificateVerifier(new DeviceRegistryBasedCertificateVerifier(adapter, this.tracer));
        adapter.setCoapEndpointFactory(endpointFactory);
        return adapter;
    }
}

