/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.hono.adapter.AbstractProtocolAdapterBase;
import org.eclipse.hono.adapter.coap.CoapAdapterMetrics;
import org.eclipse.hono.adapter.coap.CoapAdapterProperties;
import org.eclipse.hono.adapter.coap.CoapEndpointFactory;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.adapter.coap.HonoRootResource;
import org.eclipse.hono.adapter.coap.InternalErrorTracer;
import org.eclipse.hono.util.Futures;

public abstract class AbstractVertxBasedCoapAdapter<T extends CoapAdapterProperties>
extends AbstractProtocolAdapterBase<T>
implements CoapProtocolAdapter {
    protected Endpoint secureEndpoint;
    protected Endpoint insecureEndpoint;
    private final Set<Resource> resourcesToAdd = new HashSet<Resource>();
    private CoapEndpointFactory endpointFactory;
    private CoapServer server;
    private CoapAdapterMetrics metrics = CoapAdapterMetrics.NOOP;

    public final void setCoapEndpointFactory(CoapEndpointFactory factory) {
        this.endpointFactory = Objects.requireNonNull(factory);
    }

    public final void setMetrics(CoapAdapterMetrics metrics) {
        Optional.ofNullable(metrics).ifPresent(m -> this.log.info("reporting metrics using [{}]", (Object)metrics.getClass().getName()));
        this.metrics = metrics;
    }

    @Override
    public final CoapAdapterMetrics getMetrics() {
        return this.metrics;
    }

    public final void addResources(Set<Resource> resources) {
        this.resourcesToAdd.addAll((Collection<Resource>)Objects.requireNonNull(resources));
    }

    public final int getPortDefaultValue() {
        return 5684;
    }

    public final int getInsecurePortDefaultValue() {
        return 5683;
    }

    protected final int getActualPort() {
        return Optional.ofNullable(this.secureEndpoint).map(ep -> ep.getAddress().getPort()).orElse(-1);
    }

    protected final int getActualInsecurePort() {
        return Optional.ofNullable(this.insecureEndpoint).map(ep -> ep.getAddress().getPort()).orElse(-1);
    }

    public final void setCoapServer(CoapServer server) {
        Objects.requireNonNull(server);
        this.server = server;
    }

    @Override
    public final Endpoint getSecureEndpoint() {
        return this.secureEndpoint;
    }

    @Override
    public final Endpoint getInsecureEndpoint() {
        return this.insecureEndpoint;
    }

    @Override
    public final void runOnContext(Handler<Void> codeToRun) {
        this.context.runOnContext(codeToRun);
    }

    public final void doStart(Promise<Void> startPromise) {
        Optional.ofNullable(this.server).map(Future::succeededFuture).orElseGet(this::createServer).compose(serverToStart -> this.preStartup().map(serverToStart)).onSuccess(this::addResources).compose(serverToStart -> Futures.executeBlocking((Vertx)this.vertx, () -> {
            serverToStart.start();
            return serverToStart;
        })).compose(serverToStart -> {
            try {
                this.onStartupSuccess();
                return Future.succeededFuture((Object)null);
            }
            catch (Exception t) {
                this.log.error("error executing onStartupSuccess", (Throwable)t);
                return Future.failedFuture((Throwable)t);
            }
        }).onComplete(startPromise);
    }

    private Future<CoapServer> createServer() {
        if (this.endpointFactory == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("coapEndpointFactory property must be set if no CoAP server is set explicitly"));
        }
        this.log.info("creating new CoAP server");
        return this.endpointFactory.getCoapServerConfiguration().onFailure(t -> this.log.info("not creating coap server: {}", (Object)t.getMessage())).compose(config -> {
            CoapServer newServer = new CoapServer((Configuration)config, new int[0]){

                protected Resource createRoot() {
                    return new HonoRootResource(() -> AbstractVertxBasedCoapAdapter.this.getContext());
                }
            };
            InternalErrorTracer internalErrorTracer = new InternalErrorTracer(this.getTypeName(), this.tracer);
            Future secureEndpointFuture = this.endpointFactory.getSecureEndpoint().onFailure(t -> this.log.info("not creating secure endpoint: {}", (Object)t.getMessage())).onSuccess(ep -> {
                ep.addInterceptor((MessageInterceptor)internalErrorTracer);
                newServer.addEndpoint(ep);
                this.secureEndpoint = ep;
            });
            Future insecureEndpointFuture = this.endpointFactory.getInsecureEndpoint().onFailure(t -> this.log.info("not creating insecure endpoint: {}", (Object)t.getMessage())).onSuccess(ep -> {
                ep.addInterceptor((MessageInterceptor)internalErrorTracer);
                newServer.addEndpoint(ep);
                this.insecureEndpoint = ep;
            });
            return Future.any((Future)insecureEndpointFuture, (Future)secureEndpointFuture).map(ok -> {
                this.server = newServer;
                return newServer;
            });
        });
    }

    private void addResources(CoapServer startingServer) {
        this.resourcesToAdd.forEach(resource -> {
            this.log.info("adding resource to CoAP server [name: {}]", (Object)resource.getName());
            startingServer.add(new Resource[]{resource});
        });
        this.resourcesToAdd.clear();
    }

    protected Future<Void> preStartup() {
        return Future.succeededFuture();
    }

    protected void onStartupSuccess() {
    }

    public final void doStop(Promise<Void> stopPromise) {
        try {
            this.preShutdown();
        }
        catch (Exception e) {
            this.log.error("error in preShutdown", (Throwable)e);
        }
        Futures.executeBlocking((Vertx)this.vertx, () -> {
            if (this.server != null) {
                this.server.stop();
            }
            return null;
        }).compose(ok -> this.postShutdown()).onComplete(stopPromise);
    }

    protected void preShutdown() {
    }

    protected Future<Void> postShutdown() {
        return Future.succeededFuture();
    }
}

