/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import java.util.Objects;
import org.eclipse.hono.service.auth.DeviceUser;

public final class RequestDeviceAndAuth {
    private final DeviceUser originDevice;
    private final String authId;
    private final DeviceUser authenticatedDevice;

    public RequestDeviceAndAuth(DeviceUser originDevice, String authId, DeviceUser authenticatedDevice) {
        this.originDevice = Objects.requireNonNull(originDevice);
        this.authId = authId;
        this.authenticatedDevice = authenticatedDevice;
    }

    public DeviceUser getOriginDevice() {
        return this.originDevice;
    }

    public String getAuthId() {
        return this.authId;
    }

    public DeviceUser getAuthenticatedDevice() {
        return this.authenticatedDevice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.originDevice);
        if (this.authenticatedDevice == null) {
            sb.append(", unauthenticated");
        } else if (!this.authenticatedDevice.equals(this.originDevice)) {
            sb.append(", via gateway ").append(this.authenticatedDevice);
        }
        sb.append(']');
        return sb.toString();
    }
}

