/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.hono.adapter.MapBasedTelemetryExecutionContext;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.TenantObject;

public final class CoapContext
extends MapBasedTelemetryExecutionContext {
    public static final String PARAM_EMPTY_CONTENT = "empty";
    static final String PARAM_PIGGYBACKED = "piggy";
    private static final Set<String> SHORT_EP_NAMES = Set.of("t", "e", "cr");
    private final CoapExchange exchange;
    private final DeviceUser originDevice;
    private final String authId;
    private final AtomicBoolean acceptTimerFlag = new AtomicBoolean(false);
    private final AtomicBoolean acceptFlag = new AtomicBoolean(false);
    private Timer.Sample timer;

    private CoapContext(CoapExchange exchange, DeviceUser originDevice, DeviceUser authenticatedDevice, String authId, Span span) {
        super(span, authenticatedDevice);
        this.exchange = exchange;
        this.originDevice = originDevice;
        this.authId = authId;
    }

    public static CoapContext fromRequest(CoapExchange request, DeviceUser originDevice, DeviceUser authenticatedDevice, String authId, Span span) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(originDevice);
        Objects.requireNonNull(span);
        return new CoapContext(request, originDevice, authenticatedDevice, authId, span);
    }

    public static CoapContext fromRequest(CoapExchange request, DeviceUser originDevice, DeviceUser authenticatedDevice, String authId, Span span, Timer.Sample timer) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(originDevice);
        Objects.requireNonNull(span);
        Objects.requireNonNull(timer);
        CoapContext result = new CoapContext(request, originDevice, authenticatedDevice, authId, span);
        result.timer = timer;
        return result;
    }

    public DeviceUser getOriginDevice() {
        return this.originDevice;
    }

    public String getGatewayId() {
        if (this.isDeviceAuthenticated() && !this.getOriginDevice().getDeviceId().equals(this.getAuthenticatedDevice().getDeviceId())) {
            return this.getAuthenticatedDevice().getDeviceId();
        }
        return null;
    }

    public String getTenantId() {
        return this.originDevice.getTenantId();
    }

    public String getAuthId() {
        return this.authId;
    }

    public void startAcceptTimer(Vertx vertx, TenantObject tenant, long timeoutMillis) {
        Objects.requireNonNull(vertx, "vert.x");
        Objects.requireNonNull(tenant, "tenant");
        long ackTimeout = Optional.ofNullable(tenant.getAdapter("hono-coap")).map(config -> {
            long effectiveTimeoutMillis = timeoutMillis;
            Object value = config.getExtensions().get("timeoutToAck");
            if (value instanceof Number) {
                effectiveTimeoutMillis = ((Number)value).longValue();
                if (timeoutMillis > 0L && effectiveTimeoutMillis == 0L && this.isPiggyBackedResponseSupportedByDevice()) {
                    Object deviceTriggeredValue = config.getExtensions().get("deviceTriggeredTimeoutToAck");
                    effectiveTimeoutMillis = deviceTriggeredValue instanceof Number ? ((Number)deviceTriggeredValue).longValue() : timeoutMillis;
                }
            }
            return effectiveTimeoutMillis;
        }).orElse(timeoutMillis);
        if (this.acceptTimerFlag.compareAndSet(false, true)) {
            if (ackTimeout < 0L) {
                return;
            }
            if (ackTimeout == 0L) {
                this.accept();
            } else if (!this.acceptFlag.get()) {
                vertx.setTimer(ackTimeout, id -> this.accept());
            }
        }
    }

    public CoapExchange getExchange() {
        return this.exchange;
    }

    public Buffer getPayload() {
        byte[] payload = this.exchange.getRequestPayload();
        if (payload == null || payload.length == 0) {
            return Buffer.buffer();
        }
        return Buffer.buffer((byte[])payload);
    }

    public String getContentType() {
        if (this.isEmptyNotification()) {
            return "application/vnd.eclipse-hono-empty-notification";
        }
        if (this.exchange.getRequestOptions().hasContentFormat()) {
            return MediaTypeRegistry.toString((int)this.exchange.getRequestOptions().getContentFormat());
        }
        return null;
    }

    public Timer.Sample getTimer() {
        return this.timer;
    }

    public String getQueryParameter(String name) {
        return this.exchange.getQueryParameter(name);
    }

    public Integer getTimeUntilDisconnect() {
        return this.getIntegerQueryParameter("hono-ttd");
    }

    public String getCommandRequestId() {
        List pathList = this.exchange.getRequestOptions().getUriPath();
        if (pathList.size() == 2 || pathList.size() == 4) {
            return (String)pathList.get(pathList.size() - 1);
        }
        return null;
    }

    public Integer getCommandResponseStatus() {
        return this.getIntegerQueryParameter("hono-cmd-status");
    }

    private boolean isPiggyBackedResponseSupportedByDevice() {
        return this.exchange.getQueryParameter(PARAM_PIGGYBACKED) != null;
    }

    public boolean isEmptyNotification() {
        return this.exchange.getQueryParameter(PARAM_EMPTY_CONTENT) != null;
    }

    public boolean isConfirmable() {
        return this.exchange.advanced().getRequest().isConfirmable();
    }

    public void respondWithCode(CoAP.ResponseCode responseCode) {
        this.respond(new Response(responseCode));
    }

    public void respondWithCode(CoAP.ResponseCode responseCode, String description) {
        Response response = new Response(responseCode);
        Optional.ofNullable(description).ifPresent(desc -> {
            response.getOptions().setContentFormat(0);
            response.setPayload(description);
        });
        this.respond(response);
    }

    public CoAP.ResponseCode respond(Response response) {
        this.acceptFlag.set(true);
        this.exchange.respond(response);
        return response.getCode();
    }

    public void accept() {
        if (this.acceptFlag.compareAndSet(false, true)) {
            this.exchange.accept();
        }
    }

    private Integer getIntegerQueryParameter(String parameterName) {
        return Optional.ofNullable(this.exchange.getQueryParameter(parameterName)).map(value -> {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).orElse(null);
    }

    public QoS getRequestedQos() {
        return this.isConfirmable() ? QoS.AT_LEAST_ONCE : QoS.AT_MOST_ONCE;
    }

    public Optional<Duration> getTimeToLive() {
        return Optional.empty();
    }

    public String getOrigAddress() {
        return "/" + this.exchange.getRequestOptions().getUriPathString();
    }

    public boolean hasShortEndpointName() {
        String ep = (String)this.exchange.getRequestOptions().getUriPath().get(0);
        return SHORT_EP_NAMES.contains(ep);
    }
}

