/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.hono.adapter.coap.CoapConstants;
import org.eclipse.hono.adapter.coap.CoapContext;
import org.eclipse.hono.adapter.coap.CoapErrorResponse;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.tracing.TenantTraceSamplingHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TracingSupportingHonoResource
extends CoapResource {
    private static final Logger LOG = LoggerFactory.getLogger(TracingSupportingHonoResource.class);
    private static final String MSG_NOT_IMPLEMENTED = "not implemented";
    private final Tracer tracer;
    private final CoapProtocolAdapter adapter;

    protected TracingSupportingHonoResource(CoapProtocolAdapter adapter, Tracer tracer, String resourceName) {
        super(resourceName);
        this.adapter = Objects.requireNonNull(adapter);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public Resource getChild(String name) {
        return this;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected CoapProtocolAdapter getAdapter() {
        return this.adapter;
    }

    protected static Device getAuthenticatedDevice(CoapExchange exchange) {
        return Optional.ofNullable(exchange.advanced().getRequest().getSourceContext()).map(EndpointContext::getPeerIdentity).filter(ExtensiblePrincipal.class::isInstance).map(ExtensiblePrincipal.class::cast).map(ExtensiblePrincipal::getExtendedInfo).map(info -> (Device)info.get("hono-device", Device.class)).orElse(null);
    }

    public static String getAuthId(CoapExchange exchange) {
        Principal peerIdentity = exchange.advanced().getRequest().getSourceContext().getPeerIdentity();
        if (!(peerIdentity instanceof ExtensiblePrincipal)) {
            return null;
        }
        ExtensiblePrincipal extPrincipal = (ExtensiblePrincipal)peerIdentity;
        return (String)extPrincipal.getExtendedInfo().get("hono-auth-id", String.class);
    }

    private Span newSpan(Exchange exchange) {
        return TracingHelper.buildServerChildSpan((Tracer)this.tracer, null, (String)this.getSpanName(exchange), (String)this.adapter.getTypeName()).withTag((Tag)Tags.HTTP_METHOD, (Object)exchange.getRequest().getCode().name()).withTag(Tags.HTTP_URL.getKey(), exchange.getRequest().getOptions().getUriString()).withTag((Tag)CoapConstants.TAG_COAP_MESSAGE_TYPE, (Object)exchange.getRequest().getType().name()).start();
    }

    protected abstract String getSpanName(Exchange var1);

    public void handleRequest(Exchange exchange) {
        Span currentSpan = this.newSpan(exchange);
        final AtomicReference<Object> responseCode = new AtomicReference<Object>(null);
        CoapExchange coapExchange = new CoapExchange(exchange, this){

            public void respond(Response response) {
                super.respond(response);
                responseCode.set(response.getCode());
            }
        };
        (switch (exchange.getRequest().getCode()) {
            case CoAP.Code.POST -> this.createCoapContextForPost(coapExchange, currentSpan).compose(coapContext -> this.applyTraceSamplingPriority((CoapContext)((Object)coapContext), currentSpan)).compose(this::handlePostRequest);
            case CoAP.Code.PUT -> this.createCoapContextForPut(coapExchange, currentSpan).compose(coapContext -> this.applyTraceSamplingPriority((CoapContext)((Object)coapContext), currentSpan)).compose(this::handlePutRequest);
            default -> Future.failedFuture((Throwable)new ClientErrorException(405));
        }).map(ok -> {
            if (responseCode.get() == null) {
                throw new ServerErrorException(500, "no CoAP response sent");
            }
            return (CoAP.ResponseCode)responseCode.get();
        }).otherwise(t -> {
            LOG.debug("error handling request", t);
            TracingHelper.logError((Span)currentSpan, (Throwable)t);
            Response response = CoapErrorResponse.newResponse(t, CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
            coapExchange.respond(response);
            return response.getCode();
        }).onSuccess(code -> {
            LOG.debug("finished processing of request [response code: {}]", code);
            CoapConstants.TAG_COAP_RESPONSE_CODE.set(currentSpan, code.toString());
        }).onComplete(r -> currentSpan.finish());
    }

    protected Future<CoapContext> createCoapContextForPost(CoapExchange coapExchange, Span span) {
        return Future.failedFuture((Throwable)new ServerErrorException(501));
    }

    protected Future<CoapContext> createCoapContextForPut(CoapExchange coapExchange, Span span) {
        return Future.failedFuture((Throwable)new ServerErrorException(501));
    }

    protected final Future<CoapContext> applyTraceSamplingPriority(CoapContext ctx, Span span) {
        return this.adapter.getTenantClient().get(ctx.getTenantId(), span.context()).map(tenantObject -> {
            TracingHelper.setDeviceTags((Span)span, (String)tenantObject.getTenantId(), null, (String)ctx.getAuthId());
            TenantTraceSamplingHelper.applyTraceSamplingPriority((TenantObject)tenantObject, (String)ctx.getAuthId(), (Span)span);
            return ctx;
        }).recover(t -> Future.succeededFuture((Object)((Object)ctx)));
    }

    protected Future<Void> handlePostRequest(CoapContext coapContext) {
        return Future.failedFuture((Throwable)new ServerErrorException(501));
    }

    protected Future<Void> handlePutRequest(CoapContext coapContext) {
        return Future.failedFuture((Throwable)new ServerErrorException(501));
    }

    public final void handleDELETE(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }

    public final void handleFETCH(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }

    public final void handleGET(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }

    public final void handleIPATCH(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }

    public final void handlePATCH(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }

    public final void handlePOST(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }

    public final void handlePUT(CoapExchange exchange) {
        throw new UnsupportedOperationException(MSG_NOT_IMPLEMENTED);
    }
}

