/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.Optional;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptorAdapter;
import org.eclipse.californium.elements.auth.AbstractExtensiblePrincipal;
import org.eclipse.hono.adapter.coap.CoapConstants;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.tracing.TracingHelper;

public class InternalErrorTracer
extends MessageInterceptorAdapter {
    private final String coapAdapterName;
    private final Tracer tracer;

    public InternalErrorTracer(String coapAdapterName, Tracer tracer) {
        this.coapAdapterName = coapAdapterName;
        this.tracer = tracer;
    }

    public void sendResponse(Response response) {
        if (response.isInternal() && response.isError()) {
            Tracer.SpanBuilder spanBuilder = TracingHelper.buildServerChildSpan((Tracer)this.tracer, null, (String)"internal error", (String)this.coapAdapterName).withTag((Tag)CoapConstants.TAG_COAP_MESSAGE_TYPE, (Object)response.getType().name()).withTag((Tag)CoapConstants.TAG_COAP_RESPONSE_CODE, (Object)response.getCode().toString());
            Optional.ofNullable(response.getDestinationContext().getPeerIdentity()).filter(AbstractExtensiblePrincipal.class::isInstance).map(AbstractExtensiblePrincipal.class::cast).map(AbstractExtensiblePrincipal::getExtendedInfo).ifPresent(info -> {
                String authId = (String)info.get("hono-auth-id", String.class);
                Device deviceInfo = (Device)info.get("hono-device", Device.class);
                spanBuilder.withTag((Tag)TracingHelper.TAG_AUTH_ID, (Object)authId).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)deviceInfo.getDeviceId()).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)deviceInfo.getTenantId());
            });
            Span span = spanBuilder.start();
            String msg = Optional.ofNullable(response.getPayloadString()).orElseGet(() -> {
                switch (response.getCode()) {
                    case REQUEST_ENTITY_INCOMPLETE: {
                        return "blockwise transfer of request body timed out";
                    }
                    case REQUEST_ENTITY_TOO_LARGE: {
                        return "request body exceeds maximum size";
                    }
                }
                return "error while processing request";
            });
            TracingHelper.logError((Span)span, (String)msg);
            span.finish();
        }
    }
}

