/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.net.InetSocketAddress;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.hono.adapter.auth.device.AbstractDeviceCredentials;
import org.eclipse.hono.adapter.auth.device.DeviceCredentials;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.SubjectDnCredentials;
import org.eclipse.hono.adapter.auth.device.TenantServiceBasedX509Authentication;
import org.eclipse.hono.adapter.auth.device.X509AuthProvider;
import org.eclipse.hono.adapter.auth.device.X509Authentication;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.adapter.coap.DeviceInfoSupplier;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.tracing.TenantTraceSamplingHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRegistryBasedCertificateVerifier
implements NewAdvancedCertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceRegistryBasedCertificateVerifier.class);
    private static final List<X500Principal> ISSUER = List.of();
    private static final List<CertificateType> SUPPORTED_TYPES = List.of(CertificateType.X_509);
    private final CoapProtocolAdapter adapter;
    private final Tracer tracer;
    private final X509Authentication auth;
    private final DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider;
    private volatile HandshakeResultHandler californiumResultHandler;

    public DeviceRegistryBasedCertificateVerifier(CoapProtocolAdapter adapter, Tracer tracer) {
        this.adapter = Objects.requireNonNull(adapter);
        this.tracer = Objects.requireNonNull(tracer);
        this.auth = new TenantServiceBasedX509Authentication(adapter.getTenantClient(), tracer);
        this.authProvider = new X509AuthProvider(adapter.getCredentialsClient(), tracer);
    }

    private Future<AdditionalInfo> validateCertificateAndLoadDevice(ServerNames serverNames, CertPath certPath, Span span) {
        List<? extends Certificate> certificateList = certPath.getCertificates();
        Certificate[] certChain = certificateList.toArray(new Certificate[certificateList.size()]);
        Promise authResult = Promise.promise();
        List requestedHostNames = Optional.ofNullable(serverNames).map(names -> StreamSupport.stream(names.spliterator(), false).filter(serverName -> serverName.getType() == ServerName.NameType.HOST_NAME).map(ServerName::getNameAsString).collect(Collectors.toUnmodifiableList())).orElse(List.of());
        this.auth.validateClientCertificate(certChain, requestedHostNames, span.context()).onSuccess(authInfo -> {
            SubjectDnCredentials credentials = (SubjectDnCredentials)this.authProvider.getCredentials(authInfo);
            if (credentials == null) {
                authResult.fail((Throwable)new ClientErrorException(401, "failed to extract subject DN from client certificate"));
            } else {
                LOG.debug("authenticating Subject DN credentials [tenant-id: {}, subject-dn: {}]", (Object)credentials.getTenantId(), (Object)credentials.getAuthId());
                this.applyTraceSamplingPriority((DeviceCredentials)credentials, span).onSuccess(v -> this.authProvider.authenticate((AbstractDeviceCredentials)credentials, span.context(), result -> {
                    if (result.failed()) {
                        authResult.fail(result.cause());
                    } else {
                        Device device = (Device)result.result();
                        TracingHelper.TAG_TENANT_ID.set(span, device.getTenantId());
                        TracingHelper.TAG_DEVICE_ID.set(span, device.getDeviceId());
                        span.log("successfully validated device's client certificate");
                        AdditionalInfo info = DeviceInfoSupplier.createDeviceInfo(device, credentials.getAuthId());
                        authResult.complete((Object)info);
                    }
                }));
            }
        }).onFailure(t -> authResult.fail(t));
        return authResult.future();
    }

    private void validateCertificateAndLoadDevice(ConnectionId cid, CertPath certPath, ServerNames serverNames) {
        LOG.debug("validating client's X.509 certificate");
        Span span = this.tracer.buildSpan("validate client certificate").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.COMPONENT.getKey(), this.adapter.getTypeName()).start();
        this.validateCertificateAndLoadDevice(serverNames, certPath, span).map(info -> new CertificateVerificationResult(cid, certPath, info)).otherwise(t -> {
            TracingHelper.logError((Span)span, (String)"could not validate X509 for device", (Throwable)t);
            LOG.debug("error validating X509", t);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            return new CertificateVerificationResult(cid, new HandshakeException("error validating X509", alert), null);
        }).onSuccess(result -> {
            span.finish();
            this.californiumResultHandler.apply((HandshakeResult)result);
        });
    }

    private Future<Void> applyTraceSamplingPriority(DeviceCredentials deviceCredentials, Span span) {
        return this.adapter.getTenantClient().get(deviceCredentials.getTenantId(), span.context()).map(tenantObject -> {
            TracingHelper.setDeviceTags((Span)span, (String)tenantObject.getTenantId(), null, (String)deviceCredentials.getAuthId());
            TenantTraceSamplingHelper.applyTraceSamplingPriority((TenantObject)tenantObject, (String)deviceCredentials.getAuthId(), (Span)span);
            return null;
        }).recover(t -> Future.succeededFuture());
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
        this.californiumResultHandler = resultHandler;
    }

    public List<CertificateType> getSupportedCertificateTypes() {
        return SUPPORTED_TYPES;
    }

    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
        try {
            CertPath certChain = message.getCertificateChain();
            if (certChain == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                throw new HandshakeException("RPK not supported", alert);
            }
            List<? extends Certificate> certificates = certChain.getCertificates();
            if (certificates.isEmpty()) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                throw new HandshakeException("client certificate chain must not be empty", alert);
            }
            Certificate clientCertificate = certificates.get(0);
            if (clientCertificate instanceof X509Certificate && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)((X509Certificate)clientCertificate), (boolean)clientUsage)) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                throw new HandshakeException("certificate cannot be used for client authentication", alert);
            }
            this.adapter.runOnContext((Handler<Void>)((Handler)v -> this.validateCertificateAndLoadDevice(cid, certChain, serverName)));
            return null;
        }
        catch (HandshakeException e) {
            LOG.debug("certificate validation failed", (Throwable)e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    public List<X500Principal> getAcceptedIssuers() {
        return ISSUER;
    }
}

