/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.adapter.MapperEndpoint;
import org.eclipse.hono.adapter.MapperEndpointOptions;
import org.eclipse.hono.adapter.ProtocolAdapterOptions;
import org.eclipse.hono.config.ServiceConfigProperties;

public class ProtocolAdapterProperties
extends ServiceConfigProperties {
    public static final Duration DEFAULT_TENANT_IDLE_TIMEOUT = Duration.ZERO;
    public static final int DEFAULT_GC_HEAP_PERCENTAGE = 25;
    private boolean authenticationRequired = true;
    private boolean jmsVendorPropsEnabled = false;
    private boolean defaultsEnabled = true;
    private int maxConnections = 0;
    private Duration tenantIdleTimeout = DEFAULT_TENANT_IDLE_TIMEOUT;
    private int gcHeapPercentage = 25;
    private Map<String, MapperEndpoint> mapperEndpoints = new HashMap<String, MapperEndpoint>();

    public ProtocolAdapterProperties() {
    }

    public ProtocolAdapterProperties(ProtocolAdapterOptions options) {
        super(options.serviceOptions());
        this.authenticationRequired = options.authenticationRequired();
        this.defaultsEnabled = options.defaultsEnabled();
        this.gcHeapPercentage = options.gcHeapPercentage();
        this.jmsVendorPropsEnabled = options.jmsVendorPropsEnabled();
        options.mapperEndpoints().entrySet().forEach(entry -> this.mapperEndpoints.put((String)entry.getKey(), new MapperEndpoint((MapperEndpointOptions)entry.getValue())));
        this.maxConnections = options.maxConnections();
        this.tenantIdleTimeout = options.tenantIdleTimeout();
    }

    public final boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public final void setAuthenticationRequired(boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
    }

    public final boolean isJmsVendorPropsEnabled() {
        return this.jmsVendorPropsEnabled;
    }

    public final void setJmsVendorPropsEnabled(boolean flag) {
        this.jmsVendorPropsEnabled = flag;
    }

    public final boolean isDefaultsEnabled() {
        return this.defaultsEnabled;
    }

    public final void setDefaultsEnabled(boolean flag) {
        this.defaultsEnabled = flag;
    }

    public final int getMaxConnections() {
        return this.maxConnections;
    }

    public final void setMaxConnections(int maxConnections) {
        if (maxConnections < 0) {
            throw new IllegalArgumentException("connection limit must be a positive integer");
        }
        this.maxConnections = maxConnections;
    }

    public final int getGcHeapPercentage() {
        return this.gcHeapPercentage;
    }

    public final void setGcHeapPercentage(int share) {
        if (share < 0 || share > 100) {
            throw new IllegalArgumentException("percentage must be an integer in the range [0,100]");
        }
        this.gcHeapPercentage = share;
    }

    public final boolean isConnectionLimitConfigured() {
        return this.maxConnections > 0;
    }

    public Duration getTenantIdleTimeout() {
        return this.tenantIdleTimeout;
    }

    public void setTenantIdleTimeout(Duration tenantIdleTimeout) {
        this.tenantIdleTimeout = Objects.requireNonNull(tenantIdleTimeout);
    }

    public final void setMapperEndpoints(Map<String, MapperEndpoint> mapperEndpoints) {
        Objects.requireNonNull(mapperEndpoints);
        this.mapperEndpoints.clear();
        this.mapperEndpoints.putAll(mapperEndpoints);
    }

    public final MapperEndpoint getMapperEndpoint(String key) {
        return this.mapperEndpoints.get(key);
    }
}

