/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import io.vertx.ext.web.codec.BodyCodec;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.ResourceLimitsPeriod;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PrometheusBasedAsyncCacheLoader<K, V>
implements AsyncCacheLoader<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusBasedAsyncCacheLoader.class);
    private static final String QUERY_URI = "/api/v1/query";
    protected Clock clock = Clock.systemUTC();
    protected final Tracer tracer;
    private final WebClient client;
    private final PrometheusBasedResourceLimitChecksConfig config;
    private final String url;

    protected PrometheusBasedAsyncCacheLoader(WebClient webClient, PrometheusBasedResourceLimitChecksConfig config, Tracer tracer) {
        this.client = Objects.requireNonNull(webClient);
        this.config = Objects.requireNonNull(config);
        this.tracer = Objects.requireNonNull(tracer);
        this.url = String.format("%s://%s:%d%s", config.isTlsEnabled() ? "https" : "http", config.getHost(), config.getPort(), QUERY_URI);
    }

    void setClock(Clock clock) {
        this.clock = Objects.requireNonNull(clock);
    }

    protected Future<Long> executeQuery(String query, SpanContext tracingContext) {
        Span span = this.tracer.buildSpan("execute Prometheus query").addReference("follows_from", tracingContext).withTag((Tag)Tags.COMPONENT, (Object)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.HTTP_URL.getKey(), this.url).start();
        Scope spanScope = this.tracer.activateSpan(span);
        LOG.trace("running Prometheus query [URL: {}, query: {}]", (Object)this.url, (Object)query);
        span.log(Map.of("message", "running Prometheus query", "query", query));
        Promise result = Promise.promise();
        this.newQueryRequest(query).send((Handler)result);
        return result.future().onFailure(t -> {
            TracingHelper.logError((Span)span, Map.of("message", "failed to run Prometheus query", "error.kind", "Exception", "error.object", t));
            LOG.warn("failed to run Prometheus query [URL: {}, query: {}]: {}", new Object[]{this.url, query, t.getMessage()});
        }).map(response -> {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(response.statusCode()));
            return this.extractLongValue((JsonObject)response.body(), span);
        }).onComplete(r -> {
            span.finish();
            spanScope.close();
        });
    }

    private HttpRequest<JsonObject> newQueryRequest(String query) {
        HttpRequest request = this.client.post(QUERY_URI).addQueryParam("query", query).expect(ResponsePredicate.SC_OK);
        if (this.config.getQueryTimeout() > 0L) {
            request.addQueryParam("timeout", String.format("%dms", this.config.getQueryTimeout()));
            request.timeout(this.config.getQueryTimeout() + 100L);
        }
        if (!Strings.isNullOrEmpty((Object)this.config.getUsername()) && !Strings.isNullOrEmpty((Object)this.config.getPassword())) {
            request.basicAuthentication(this.config.getUsername(), this.config.getPassword());
        }
        return request.as(BodyCodec.jsonObject());
    }

    protected final Long extractLongValue(JsonObject response, Span span) {
        Objects.requireNonNull(response);
        try {
            String status = response.getString("status");
            if ("error".equals(status)) {
                String errorMessage = response.getString("error");
                TracingHelper.logError((Span)span, Map.of("message", String.format("error executing query: %s", errorMessage), "status", status, "error.kind", response.getString("errorType")));
                LOG.debug("error executing query [status: {}, error type: {}, error: {}]", new Object[]{status, response.getString("errorType"), errorMessage});
                return 0L;
            }
            JsonObject data = response.getJsonObject("data", new JsonObject());
            JsonArray result = data.getJsonArray("result");
            if (result != null) {
                String value;
                JsonArray valueArray;
                if (result.size() == 0) {
                    span.log("no metrics available (yet)");
                    return 0L;
                }
                if (result.size() == 1 && result.getJsonObject(0) != null && (valueArray = result.getJsonObject(0).getJsonArray("value")) != null && valueArray.size() == 2 && (value = valueArray.getString(1)) != null && !value.isEmpty()) {
                    return Long.parseLong(value);
                }
            }
            String jsonResponse = response.encodePrettily();
            TracingHelper.logError((Span)span, Map.of("message", "server returned malformed response", "response", jsonResponse));
            LOG.debug("server returned malformed response: {}", (Object)jsonResponse);
        }
        catch (Exception e) {
            String jsonResponse = response.encodePrettily();
            TracingHelper.logError((Span)span, Map.of("message", "server returned malformed response", "response", jsonResponse));
            LOG.debug("server returned malformed response: {}", (Object)jsonResponse);
        }
        return 0L;
    }

    protected long calculateEffectiveLimit(Instant effectiveSince, Instant targetDateTime, ResourceLimitsPeriod.PeriodMode periodMode, long configuredLimit) {
        Objects.requireNonNull(effectiveSince, "effective since");
        Objects.requireNonNull(targetDateTime, "target date-time");
        Objects.requireNonNull(periodMode, "period mode");
        if (targetDateTime.isBefore(effectiveSince)) {
            return 0L;
        }
        if (ResourceLimitsPeriod.PeriodMode.monthly == periodMode && configuredLimit > 0L) {
            ZonedDateTime effectiveSinceZonedDateTime = ZonedDateTime.ofInstant(effectiveSince, ZoneOffset.UTC);
            ZonedDateTime targetZonedDateTime = ZonedDateTime.ofInstant(targetDateTime, ZoneOffset.UTC);
            if (YearMonth.from(targetZonedDateTime).equals(YearMonth.from(effectiveSinceZonedDateTime))) {
                ZonedDateTime startOfNextAccountingPeriod = effectiveSinceZonedDateTime.with(TemporalAdjusters.firstDayOfNextMonth()).withHour(0).withMinute(0).withSecond(0).withNano(0);
                long minutesTillStartOfNextAccountingPeriod = Math.max(1L, Duration.between(effectiveSinceZonedDateTime, startOfNextAccountingPeriod).toMinutes());
                long lengthOfCurrentMonthInMinutes = 1440L * effectiveSinceZonedDateTime.range(ChronoField.DAY_OF_MONTH).getMaximum();
                return (long)Math.ceil((double)minutesTillStartOfNextAccountingPeriod * (double)configuredLimit / (double)lengthOfCurrentMonthInMinutes);
            }
        }
        return configuredLimit;
    }
}

