/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import io.micrometer.core.instrument.Timer;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.opentracing.SpanContext;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.AdapterConnectionsExceededException;
import org.eclipse.hono.adapter.AdapterDisabledException;
import org.eclipse.hono.adapter.AuthorizationException;
import org.eclipse.hono.adapter.ConnectionDurationExceededException;
import org.eclipse.hono.adapter.DataVolumeExceededException;
import org.eclipse.hono.adapter.MessagingClientProviders;
import org.eclipse.hono.adapter.ProtocolAdapter;
import org.eclipse.hono.adapter.ProtocolAdapterProperties;
import org.eclipse.hono.adapter.RegistrationAssertionException;
import org.eclipse.hono.adapter.TelemetryExecutionContext;
import org.eclipse.hono.adapter.TenantConnectionsExceededException;
import org.eclipse.hono.adapter.limiting.ConnectionLimitManager;
import org.eclipse.hono.adapter.monitoring.ConnectionEventProducer;
import org.eclipse.hono.adapter.resourcelimits.NoopResourceLimitChecks;
import org.eclipse.hono.adapter.resourcelimits.ResourceLimitChecks;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.CommandRouterClient;
import org.eclipse.hono.client.command.ProtocolAdapterCommandConsumerFactory;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.client.registry.DeviceDisabledOrNotRegisteredException;
import org.eclipse.hono.client.registry.DeviceRegistrationClient;
import org.eclipse.hono.client.registry.GatewayDisabledOrNotRegisteredException;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.client.registry.TenantDisabledOrNotRegisteredException;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.TelemetrySender;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.auth.ValidityBasedTrustOptions;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.util.ServiceBaseUtils;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TenantObject;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T>
implements ProtocolAdapter {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String KEY_MICROMETER_SAMPLE = "micrometer.sample";
    private ProtocolAdapterCommandConsumerFactory commandConsumerFactory;
    private CommandRouterClient commandRouterClient;
    private ConnectionLimitManager connectionLimitManager;
    private ConnectionEventProducer connectionEventProducer;
    private CredentialsClient credentialsClient;
    private DeviceRegistrationClient registrationClient;
    private ResourceLimitChecks resourceLimitChecks = new NoopResourceLimitChecks();
    private TenantClient tenantClient;
    private MessagingClientProviders messagingClientProviders;

    protected static final void addMicrometerSample(CommandContext ctx, Timer.Sample sample) {
        Objects.requireNonNull(ctx);
        ctx.put(KEY_MICROMETER_SAMPLE, (Object)sample);
    }

    protected static final Timer.Sample getMicrometerSample(CommandContext ctx) {
        Objects.requireNonNull(ctx);
        return (Timer.Sample)ctx.get(KEY_MICROMETER_SAMPLE);
    }

    public final void setTenantClient(TenantClient client) {
        this.tenantClient = Objects.requireNonNull(client);
    }

    @Override
    public final TenantClient getTenantClient() {
        return this.tenantClient;
    }

    public final void setCommandRouterClient(CommandRouterClient client) {
        this.commandRouterClient = Objects.requireNonNull(client);
        this.log.info("using Command Router client [{}]", (Object)client.getClass().getName());
    }

    public void setMessagingClientProviders(MessagingClientProviders messagingClientProviders) {
        Objects.requireNonNull(messagingClientProviders);
        this.messagingClientProviders = messagingClientProviders;
    }

    @Override
    public final TelemetrySender getTelemetrySender(TenantObject tenant) {
        return this.messagingClientProviders.getTelemetrySender(tenant);
    }

    @Override
    public final EventSender getEventSender(TenantObject tenant) {
        return this.messagingClientProviders.getEventSender(tenant);
    }

    @Override
    public final CommandResponseSender getCommandResponseSender(MessagingType messagingType, TenantObject tenant) {
        return this.messagingClientProviders.getCommandResponseSender(messagingType, tenant);
    }

    public final void setRegistrationClient(DeviceRegistrationClient client) {
        this.registrationClient = Objects.requireNonNull(client);
    }

    public final DeviceRegistrationClient getRegistrationClient() {
        return this.registrationClient;
    }

    public final void setCredentialsClient(CredentialsClient client) {
        this.credentialsClient = Objects.requireNonNull(client);
    }

    @Override
    public final CredentialsClient getCredentialsClient() {
        return this.credentialsClient;
    }

    public void setConnectionEventProducer(ConnectionEventProducer connectionEventProducer) {
        this.connectionEventProducer = Objects.requireNonNull(connectionEventProducer);
        this.log.info("using [{}] for reporting connection events, if applicable for device protocol", (Object)connectionEventProducer);
    }

    public ConnectionEventProducer getConnectionEventProducer() {
        return this.connectionEventProducer;
    }

    public final void setCommandConsumerFactory(ProtocolAdapterCommandConsumerFactory factory) {
        this.commandConsumerFactory = Objects.requireNonNull(factory);
    }

    @Override
    public final ProtocolAdapterCommandConsumerFactory getCommandConsumerFactory() {
        return this.commandConsumerFactory;
    }

    public final void setResourceLimitChecks(ResourceLimitChecks resourceLimitChecks) {
        this.resourceLimitChecks = Objects.requireNonNull(resourceLimitChecks);
    }

    protected final ResourceLimitChecks getResourceLimitChecks() {
        return this.resourceLimitChecks;
    }

    public final void setConnectionLimitManager(ConnectionLimitManager connectionLimitManager) {
        this.connectionLimitManager = connectionLimitManager;
    }

    protected final ConnectionLimitManager getConnectionLimitManager() {
        return this.connectionLimitManager;
    }

    protected final Future<Void> startInternal() {
        Promise result = Promise.promise();
        if (Strings.isNullOrEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.tenantClient == null) {
            result.fail((Throwable)new IllegalStateException("Tenant client must be set"));
        } else if (this.messagingClientProviders == null) {
            result.fail((Throwable)new IllegalStateException("Downstream messaging client providers must be set"));
        } else if (this.registrationClient == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration client must be set"));
        } else if (this.credentialsClient == null) {
            result.fail((Throwable)new IllegalStateException("Credentials client must be set"));
        } else if (this.commandConsumerFactory == null) {
            result.fail((Throwable)new IllegalStateException("Command & Control consumer factory must be set"));
        } else if (this.commandRouterClient == null) {
            result.fail((Throwable)new IllegalStateException("Command Router client must be set"));
        } else {
            this.log.info("using ResourceLimitChecks [{}]", (Object)this.resourceLimitChecks.getClass().getName());
            this.messagingClientProviders.start();
            this.tenantClient.start();
            this.registrationClient.start();
            this.credentialsClient.start();
            this.commandConsumerFactory.start();
            this.commandRouterClient.start();
            this.doStart((Promise<Void>)result);
        }
        return result.future();
    }

    protected void doStart(Promise<Void> startPromise) {
        startPromise.complete();
    }

    protected final Future<Void> stopInternal() {
        this.log.info("stopping protocol adapter");
        Promise result = Promise.promise();
        this.doStop((Promise<Void>)result);
        return result.future().compose(s -> this.closeServiceClients()).recover(t -> {
            this.log.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).map(ok -> {
            this.log.info("successfully stopped protocol adapter");
            return null;
        });
    }

    private Future<Void> closeServiceClients() {
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(this.tenantClient.stop());
        results.add(this.registrationClient.stop());
        results.add(this.credentialsClient.stop());
        results.add(this.commandConsumerFactory.stop());
        results.add(this.commandRouterClient.stop());
        results.add(this.messagingClientProviders.stop());
        return CompositeFuture.all(results).mapEmpty();
    }

    protected void doStop(Promise<Void> stopPromise) {
        stopPromise.complete();
    }

    @Override
    public final Future<TenantObject> isAdapterEnabled(TenantObject tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        if (tenantConfig.isAdapterEnabled(this.getTypeName())) {
            this.log.debug("protocol adapter [{}] is enabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
            return Future.succeededFuture((Object)tenantConfig);
        }
        if (!tenantConfig.isEnabled()) {
            this.log.debug("tenant [{}] is disabled", (Object)tenantConfig.getTenantId());
            return Future.failedFuture((Throwable)new TenantDisabledOrNotRegisteredException(tenantConfig.getTenantId(), 403));
        }
        this.log.debug("protocol adapter [{}] is disabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
        return Future.failedFuture((Throwable)((Object)new AdapterDisabledException(tenantConfig.getTenantId())));
    }

    protected Future<Void> checkConnectionLimit(TenantObject tenantConfig, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        Future connectionLimitCheckResult = this.resourceLimitChecks.isConnectionLimitReached(tenantConfig, spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)((Object)new TenantConnectionsExceededException(tenantConfig.getTenantId(), null)));
            }
            return Future.succeededFuture();
        });
        Future messageLimitCheckResult = this.checkMessageLimit(tenantConfig, 1L, spanContext).recover(t -> {
            if (ServiceInvocationException.extractStatusCode((Throwable)t) == HttpResponseStatus.TOO_MANY_REQUESTS.code()) {
                return Future.failedFuture((Throwable)((Object)new DataVolumeExceededException(tenantConfig.getTenantId(), t.getCause())));
            }
            return Future.failedFuture((Throwable)t);
        });
        return CompositeFuture.all((Future)connectionLimitCheckResult, this.checkConnectionDurationLimit(tenantConfig, spanContext), (Future)messageLimitCheckResult).mapEmpty();
    }

    @Override
    public Future<Void> checkMessageLimit(TenantObject tenantConfig, long payloadSize, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isMessageLimitReached(tenantConfig, ServiceBaseUtils.calculatePayloadSize((long)payloadSize, (TenantObject)tenantConfig), spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)new ClientErrorException(tenantConfig.getTenantId(), HttpResponseStatus.TOO_MANY_REQUESTS.code(), "tenant's accumulated message data volume exceeds configured maximum value"));
            }
            return Future.succeededFuture();
        });
    }

    protected Future<Void> checkConnectionDurationLimit(TenantObject tenantConfig, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isConnectionDurationLimitReached(tenantConfig, spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)((Object)new ConnectionDurationExceededException(tenantConfig.getTenantId(), null)));
            }
            return Future.succeededFuture();
        });
    }

    protected final Future<ResourceIdentifier> validateAddress(ResourceIdentifier address, Device authenticatedDevice) {
        Objects.requireNonNull(address);
        Promise result = Promise.promise();
        if (authenticatedDevice == null) {
            if (Strings.isNullOrEmpty((Object)address.getTenantId()) || Strings.isNullOrEmpty((Object)address.getResourceId())) {
                result.fail((Throwable)new ClientErrorException(400, "unauthenticated client must provide tenant and device ID in message address"));
            } else {
                result.complete((Object)address);
            }
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            result.fail((Throwable)new ClientErrorException(400, "message address must not contain tenant ID only"));
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && !address.getTenantId().equals(authenticatedDevice.getTenantId())) {
            result.fail((Throwable)new ClientErrorException(403, "can only publish for device of same tenant"));
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)authenticatedDevice.getDeviceId());
            result.complete((Object)resource);
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)address.getResourceId());
            result.complete((Object)resource);
        } else {
            result.complete((Object)address);
        }
        return result.future().recover(t -> {
            this.log.debug("validation failed for address [{}], device [{}]: {}", new Object[]{address, authenticatedDevice, t.getMessage()});
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<Void> checkDeviceRegistration(Device device, SpanContext context) {
        Objects.requireNonNull(device);
        return this.getRegistrationAssertion(device.getTenantId(), device.getDeviceId(), null, context).recover(t -> Future.failedFuture((Throwable)((Object)new RegistrationAssertionException(device.getTenantId(), "failed to assert registration status of " + device, (Throwable)t)))).mapEmpty();
    }

    protected final Future<Void> sendCommandResponse(TenantObject tenant, RegistrationAssertion device, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(response);
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        return this.messagingClientProviders.getCommandResponseSender(response.getMessagingType(), tenant).sendCommandResponse(tenant, device, response, context);
    }

    @Override
    public final Future<RegistrationAssertion> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient().assertRegistration(tenantId, deviceId, gwId, context)).onSuccess(assertion -> this.updateLastGateway((RegistrationAssertion)assertion, tenantId, deviceId, authenticatedDevice, context).onFailure(t -> this.log.warn("failed to update last gateway [tenantId: {}, deviceId: {}]", new Object[]{tenantId, deviceId, t}))).recover(error -> {
            int errorCode = ServiceInvocationException.extractStatusCode((Throwable)error);
            if (errorCode == 404) {
                return Future.failedFuture((Throwable)new DeviceDisabledOrNotRegisteredException(tenantId, errorCode));
            }
            if (errorCode == 403) {
                return Future.failedFuture((Throwable)new GatewayDisabledOrNotRegisteredException(tenantId, errorCode));
            }
            return Future.failedFuture((Throwable)error);
        });
    }

    protected final Future<RegistrationAssertion> updateLastGateway(RegistrationAssertion registrationAssertion, String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        if (!this.isDeviceWithMultipleViaGateways(registrationAssertion)) {
            return Future.succeededFuture((Object)registrationAssertion);
        }
        return this.getGatewayId(tenantId, deviceId, authenticatedDevice).compose(gwId -> this.commandRouterClient.setLastKnownGatewayForDevice(tenantId, deviceId, Optional.ofNullable(gwId).orElse(deviceId), context)).map((Object)registrationAssertion);
    }

    private boolean isDeviceWithMultipleViaGateways(RegistrationAssertion registrationAssertion) {
        return registrationAssertion.getAuthorizedGateways().size() > 1;
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Promise result = Promise.promise();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result.future();
    }

    protected final Future<TenantObject> getTenantConfiguration(String tenantId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().get(tenantId, context).recover(error -> Future.failedFuture((Throwable)(ServiceInvocationException.extractStatusCode((Throwable)error) == 404 ? new TenantDisabledOrNotRegisteredException(tenantId, 404) : error)));
    }

    @Override
    public final Map<String, Object> getDownstreamMessageProperties(TelemetryExecutionContext context) {
        Map<String, Object> props = Objects.requireNonNull(context).getDownstreamMessageProperties();
        props.put("orig_adapter", this.getTypeName());
        return props;
    }

    public void registerReadinessChecks(HealthCheckHandler handler) {
        ServiceClient client;
        ProtocolAdapterCommandConsumerFactory protocolAdapterCommandConsumerFactory = this.commandConsumerFactory;
        if (protocolAdapterCommandConsumerFactory instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerReadinessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.tenantClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerReadinessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.registrationClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerReadinessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.credentialsClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerReadinessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.commandRouterClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerReadinessChecks(handler);
        }
        this.messagingClientProviders.registerReadinessChecks(handler);
    }

    public void registerLivenessChecks(HealthCheckHandler handler) {
        ServiceClient client;
        this.registerEventLoopBlockedCheck(handler);
        ProtocolAdapterCommandConsumerFactory protocolAdapterCommandConsumerFactory = this.commandConsumerFactory;
        if (protocolAdapterCommandConsumerFactory instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerLivenessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.tenantClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerLivenessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.registrationClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerLivenessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.credentialsClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerLivenessChecks(handler);
        }
        if ((protocolAdapterCommandConsumerFactory = this.commandRouterClient) instanceof ServiceClient) {
            client = (ServiceClient)protocolAdapterCommandConsumerFactory;
            client.registerLivenessChecks(handler);
        }
        this.messagingClientProviders.registerLivenessChecks(handler);
    }

    protected Future<Void> sendConnectedEvent(String remoteId, Device authenticatedDevice, SpanContext context) {
        if (this.connectionEventProducer != null) {
            return Optional.ofNullable(authenticatedDevice).map(device -> this.getTenantClient().get(device.getTenantId(), context).map(this::getEventSender)).orElseGet(() -> Future.succeededFuture(null)).compose(es -> this.connectionEventProducer.connected(new ConnectionEventProducer.Context(){
                final /* synthetic */ EventSender val$es;
                {
                    this.val$es = eventSender;
                }

                @Override
                public EventSender getMessageSenderClient() {
                    return this.val$es;
                }

                @Override
                public TenantClient getTenantClient() {
                    return AbstractProtocolAdapterBase.this.getTenantClient();
                }
            }, remoteId, this.getTypeName(), authenticatedDevice, null, context));
        }
        return Future.succeededFuture();
    }

    protected Future<Void> sendDisconnectedEvent(String remoteId, Device authenticatedDevice, SpanContext context) {
        if (this.connectionEventProducer != null) {
            return Optional.ofNullable(authenticatedDevice).map(device -> this.getTenantClient().get(device.getTenantId(), context).map(this::getEventSender)).orElseGet(() -> Future.succeededFuture(null)).compose(es -> this.connectionEventProducer.disconnected(new ConnectionEventProducer.Context(){
                final /* synthetic */ EventSender val$es;
                {
                    this.val$es = eventSender;
                }

                @Override
                public EventSender getMessageSenderClient() {
                    return this.val$es;
                }

                @Override
                public TenantClient getTenantClient() {
                    return AbstractProtocolAdapterBase.this.getTenantClient();
                }
            }, remoteId, this.getTypeName(), authenticatedDevice, null, context));
        }
        return Future.succeededFuture();
    }

    @Override
    public final Future<Void> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(ttd);
        Future<RegistrationAssertion> tokenTracker = this.getRegistrationAssertion(tenant, deviceId, authenticatedDevice, context);
        Future<TenantObject> tenantConfigTracker = this.getTenantConfiguration(tenant, context);
        return CompositeFuture.all(tokenTracker, tenantConfigTracker).compose(ok -> {
            if (((TenantObject)tenantConfigTracker.result()).isAdapterEnabled(this.getTypeName())) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("orig_adapter", this.getTypeName());
                props.put("qos", QoS.AT_LEAST_ONCE.ordinal());
                props.put("ttd", ttd);
                return this.getEventSender((TenantObject)tenantConfigTracker.result()).sendEvent((TenantObject)tenantConfigTracker.result(), (RegistrationAssertion)tokenTracker.result(), "application/vnd.eclipse-hono-empty-notification", null, props, context).onSuccess(s -> this.log.debug("successfully sent TTD notification [tenant: {}, device-id: {}, TTD: {}]", new Object[]{tenant, deviceId, ttd})).onFailure(t -> this.log.debug("failed to send TTD notification [tenant: {}, device-id: {}, TTD: {}]", new Object[]{tenant, deviceId, ttd, t}));
            }
            return Future.failedFuture((Throwable)new ClientErrorException(403));
        });
    }

    public static boolean isPayloadOfIndicatedType(Buffer payload, String contentType) {
        if (payload == null || payload.length() == 0) {
            return !Strings.isNullOrEmpty((Object)contentType);
        }
        return !"application/vnd.eclipse-hono-empty-notification".equals(contentType);
    }

    protected void registerEventLoopBlockedCheck(HealthCheckHandler handler) {
        handler.register("event-loop-blocked-check", ((ProtocolAdapterProperties)((Object)this.getConfig())).getEventLoopBlockedCheckTimeout(), procedure -> {
            Context currentContext = Vertx.currentContext();
            if (currentContext != this.context) {
                this.context.runOnContext(action -> procedure.tryComplete((Object)Status.OK()));
            } else {
                this.log.debug("Protocol Adapter - HealthCheck Server context match. Assume protocol adapter is alive.");
                procedure.tryComplete((Object)Status.OK());
            }
        });
    }

    protected TrustOptions getServerTrustOptions() {
        return Optional.ofNullable(((ProtocolAdapterProperties)((Object)this.getConfig())).getTrustOptions()).orElseGet(() -> {
            if (((ProtocolAdapterProperties)((Object)((Object)this.getConfig()))).isAuthenticationRequired()) {
                return new ValidityBasedTrustOptions();
            }
            return null;
        });
    }

    public static MetricsTags.ConnectionAttemptOutcome getOutcome(Throwable e) {
        if (e instanceof AuthorizationException) {
            if (e instanceof AdapterConnectionsExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.ADAPTER_CONNECTIONS_EXCEEDED;
            }
            if (e instanceof ConnectionDurationExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.CONNECTION_DURATION_EXCEEDED;
            }
            if (e instanceof DataVolumeExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.DATA_VOLUME_EXCEEDED;
            }
            if (e instanceof RegistrationAssertionException) {
                return MetricsTags.ConnectionAttemptOutcome.REGISTRATION_ASSERTION_FAILURE;
            }
            if (e instanceof TenantConnectionsExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.TENANT_CONNECTIONS_EXCEEDED;
            }
            return MetricsTags.ConnectionAttemptOutcome.UNAUTHORIZED;
        }
        if (e instanceof AdapterDisabledException) {
            return MetricsTags.ConnectionAttemptOutcome.ADAPTER_DISABLED;
        }
        if (e instanceof ServiceInvocationException) {
            switch (((ServiceInvocationException)e).getErrorCode()) {
                case 401: {
                    return MetricsTags.ConnectionAttemptOutcome.UNAUTHORIZED;
                }
                case 503: {
                    return MetricsTags.ConnectionAttemptOutcome.UNAVAILABLE;
                }
            }
            return MetricsTags.ConnectionAttemptOutcome.UNKNOWN;
        }
        return MetricsTags.ConnectionAttemptOutcome.UNKNOWN;
    }

    protected Future<Boolean> isTerminalError(Throwable error, String deviceId, Device authenticatedDevice, SpanContext spanContext) {
        Objects.requireNonNull(error);
        if (authenticatedDevice == null) {
            return Future.succeededFuture((Object)false);
        }
        if (error instanceof DeviceDisabledOrNotRegisteredException) {
            if (deviceId != null && !authenticatedDevice.getDeviceId().equals(deviceId)) {
                return this.getRegistrationAssertion(authenticatedDevice.getTenantId(), authenticatedDevice.getDeviceId(), null, spanContext).map(ok -> false).recover(e -> Future.succeededFuture((Object)(e instanceof DeviceDisabledOrNotRegisteredException)));
            }
            return Future.succeededFuture((Object)true);
        }
        return Future.succeededFuture((Object)(error instanceof AdapterDisabledException || error instanceof GatewayDisabledOrNotRegisteredException || error instanceof TenantDisabledOrNotRegisteredException || error instanceof AuthorizationException ? 1 : 0));
    }
}

