/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.metric;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.hono.adapter.metric.DeviceConnectionDurationTracker;
import org.eclipse.hono.adapter.metric.Metrics;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.util.ServiceBaseUtils;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MicrometerBasedMetrics
implements Metrics,
SendMessageSampler.Factory {
    public static final String METER_CONNECTIONS_AUTHENTICATED = "hono.connections.authenticated";
    public static final String METER_CONNECTIONS_AUTHENTICATED_DURATION = "hono.connections.authenticated.duration";
    public static final String METER_CONNECTIONS_UNAUTHENTICATED = "hono.connections.unauthenticated";
    public static final String METER_CONNECTIONS_ATTEMPTS = "hono.connections.attempts";
    public static final String METER_MESSAGES_PAYLOAD = "hono.messages.payload";
    public static final String METER_MESSAGES_RECEIVED = "hono.messages.received";
    public static final String METER_COMMANDS_PAYLOAD = "hono.commands.payload";
    public static final String METER_COMMANDS_RECEIVED = "hono.commands.received";
    public static final String METER_DOWNSTREAM_FULL = "hono.downstream.full";
    public static final String METER_DOWNSTREAM_SENT = "hono.downstream.sent";
    public static final String METER_DOWNSTREAM_TIMEOUT = "hono.downstream.timeout";
    private static final long DEFAULT_TENANT_IDLE_TIMEOUT = ProtocolAdapterProperties.DEFAULT_TENANT_IDLE_TIMEOUT.toMillis();
    private static final long DEVICE_CONNECTION_DURATION_RECORDING_INTERVAL_IN_MS = TimeUnit.SECONDS.toMillis(10L);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final MeterRegistry registry;
    private final Map<String, AtomicLong> authenticatedConnections = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, DeviceConnectionDurationTracker> connectionDurationTrackers = new ConcurrentHashMap<String, DeviceConnectionDurationTracker>();
    private final Map<String, Long> lastSeenTimestampPerTenant = new ConcurrentHashMap<String, Long>();
    private final AtomicLong unauthenticatedConnections;
    private final AtomicInteger totalCurrentConnections = new AtomicInteger();
    private final Vertx vertx;
    private long tenantIdleTimeout = DEFAULT_TENANT_IDLE_TIMEOUT;

    protected MicrometerBasedMetrics(MeterRegistry registry, Vertx vertx) {
        Objects.requireNonNull(registry);
        Objects.requireNonNull(vertx);
        this.log.info("using Metrics Registry implementation [{}]", (Object)registry.getClass().getName());
        this.registry = registry;
        this.vertx = vertx;
        this.registry.config().onMeterRemoved(meter -> {
            if (METER_CONNECTIONS_AUTHENTICATED.equals(meter.getId().getName())) {
                this.authenticatedConnections.remove(meter.getId().getTag("tenant"));
            }
        });
        this.unauthenticatedConnections = (AtomicLong)registry.gauge(METER_CONNECTIONS_UNAUTHENTICATED, (Number)new AtomicLong());
    }

    @Autowired(required=false)
    public void setProtocolAdapterProperties(ProtocolAdapterProperties config) {
        Objects.requireNonNull(config);
        this.tenantIdleTimeout = config.getTenantIdleTimeout().toMillis();
    }

    @Override
    public final void incrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
        long tenantSpecificAuthenticatedConnections = this.gaugeForTenant(METER_CONNECTIONS_AUTHENTICATED, this.authenticatedConnections, tenantId, AtomicLong::new).incrementAndGet();
        this.totalCurrentConnections.incrementAndGet();
        this.trackDeviceConnectionDuration(tenantId, tenantSpecificAuthenticatedConnections);
        this.updateLastSeenTimestamp(tenantId);
    }

    @Override
    public final void decrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
        long tenantSpecificAuthenticatedConnections = this.gaugeForTenant(METER_CONNECTIONS_AUTHENTICATED, this.authenticatedConnections, tenantId, AtomicLong::new).decrementAndGet();
        this.totalCurrentConnections.decrementAndGet();
        this.trackDeviceConnectionDuration(tenantId, tenantSpecificAuthenticatedConnections);
        this.updateLastSeenTimestamp(tenantId);
    }

    @Override
    public final void incrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.incrementAndGet();
        this.totalCurrentConnections.incrementAndGet();
    }

    @Override
    public final void decrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.decrementAndGet();
        this.totalCurrentConnections.decrementAndGet();
    }

    @Override
    public void reportConnectionAttempt(MetricsTags.ConnectionAttemptOutcome outcome, String tenantId) {
        this.reportConnectionAttempt(outcome, tenantId, null);
    }

    @Override
    public void reportConnectionAttempt(MetricsTags.ConnectionAttemptOutcome outcome, String tenantId, String cipherSuite) {
        Objects.requireNonNull(outcome);
        Tags tags = Tags.of((Tag[])new Tag[]{outcome.asTag()}).and(new Tag[]{MetricsTags.getTenantTag((String)tenantId)}).and(new Tag[]{MetricsTags.getCipherSuiteTag((String)cipherSuite)});
        Counter.builder((String)METER_CONNECTIONS_ATTEMPTS).tags((Iterable)tags).register(this.registry).increment();
    }

    @Override
    public int getNumberOfConnections() {
        return this.totalCurrentConnections.get();
    }

    @Override
    public Timer.Sample startTimer() {
        return Timer.start((MeterRegistry)this.registry);
    }

    @Override
    public void reportTelemetry(MetricsTags.EndpointType type, String tenantId, TenantObject tenantObject, MetricsTags.ProcessingOutcome outcome, MetricsTags.QoS qos, int payloadSize, Timer.Sample timer) {
        this.reportTelemetry(type, tenantId, tenantObject, outcome, qos, payloadSize, MetricsTags.TtdStatus.NONE, timer);
    }

    @Override
    public final void reportTelemetry(MetricsTags.EndpointType type, String tenantId, TenantObject tenantObject, MetricsTags.ProcessingOutcome outcome, MetricsTags.QoS qos, int payloadSize, MetricsTags.TtdStatus ttdStatus, Timer.Sample timer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(qos);
        Objects.requireNonNull(ttdStatus);
        Objects.requireNonNull(timer);
        if (type != MetricsTags.EndpointType.TELEMETRY && type != MetricsTags.EndpointType.EVENT) {
            throw new IllegalArgumentException("invalid type, must be either telemetry or event");
        }
        if (payloadSize < 0) {
            throw new IllegalArgumentException("payload size must not be negative");
        }
        Tags tags = Tags.of((Tag[])new Tag[]{type.asTag()}).and(new Tag[]{MetricsTags.getTenantTag((String)tenantId)}).and(new Tag[]{outcome.asTag()}).and(new Tag[]{qos.asTag()}).and(new Tag[]{ttdStatus.asTag()});
        timer.stop(this.registry.timer(METER_MESSAGES_RECEIVED, (Iterable)tags));
        DistributionSummary.builder((String)METER_MESSAGES_PAYLOAD).baseUnit("bytes").minimumExpectedValue(Double.valueOf(0.0)).tags((Iterable)tags).register(this.registry).record((double)ServiceBaseUtils.calculatePayloadSize((long)payloadSize, (TenantObject)tenantObject));
        this.updateLastSeenTimestamp(tenantId);
    }

    @Override
    public void reportCommand(MetricsTags.Direction direction, String tenantId, TenantObject tenantObject, MetricsTags.ProcessingOutcome outcome, int payloadSize, Timer.Sample timer) {
        Objects.requireNonNull(direction);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(timer);
        if (payloadSize < 0) {
            throw new IllegalArgumentException("payload size must not be negative");
        }
        Tags tags = Tags.of((Tag[])new Tag[]{direction.asTag()}).and(new Tag[]{MetricsTags.getTenantTag((String)tenantId)}).and(new Tag[]{outcome.asTag()});
        timer.stop(this.registry.timer(METER_COMMANDS_RECEIVED, (Iterable)tags));
        DistributionSummary.builder((String)METER_COMMANDS_PAYLOAD).baseUnit("bytes").minimumExpectedValue(Double.valueOf(0.0)).tags((Iterable)tags).register(this.registry).record((double)ServiceBaseUtils.calculatePayloadSize((long)payloadSize, (TenantObject)tenantObject));
        this.updateLastSeenTimestamp(tenantId);
    }

    protected <K, V extends Number> V gaugeForKey(String name, Map<K, V> map, K key, Tags tags, Supplier<V> instanceSupplier) {
        return (V)map.computeIfAbsent(key, a -> this.registry.gauge(name, (Iterable)tags, (Number)instanceSupplier.get()));
    }

    protected <V extends Number> V gaugeForTenant(String name, Map<String, V> map, String tenant, Supplier<V> instanceSupplier) {
        return this.gaugeForKey(name, map, tenant, Tags.of((Tag[])new Tag[]{MetricsTags.getTenantTag((String)tenant)}), instanceSupplier);
    }

    Map<String, Long> getLastSeenTimestampPerTenant() {
        return this.lastSeenTimestampPerTenant;
    }

    private void updateLastSeenTimestamp(String tenantId) {
        if (this.tenantIdleTimeout == DEFAULT_TENANT_IDLE_TIMEOUT) {
            return;
        }
        Long previousVal = this.lastSeenTimestampPerTenant.put(tenantId, System.currentTimeMillis());
        if (previousVal == null) {
            this.newTenantTimeoutTimer(tenantId, this.tenantIdleTimeout);
        }
    }

    private void newTenantTimeoutTimer(String tenantId, long delay) {
        this.vertx.setTimer(delay, id -> {
            Long lastSeen = this.lastSeenTimestampPerTenant.get(tenantId);
            long remaining = this.tenantIdleTimeout - (System.currentTimeMillis() - lastSeen);
            if (remaining > 0L) {
                this.newTenantTimeoutTimer(tenantId, remaining);
            } else if (!this.isConnected(tenantId) && this.lastSeenTimestampPerTenant.remove(tenantId, lastSeen)) {
                this.handleTenantTimeout(tenantId);
            } else {
                this.newTenantTimeoutTimer(tenantId, this.tenantIdleTimeout);
            }
        });
    }

    private boolean isConnected(String tenantId) {
        AtomicLong count = this.authenticatedConnections.get(tenantId);
        return count != null && count.get() > 0L;
    }

    private void handleTenantTimeout(String tenantId) {
        Tags tenantTag = Tags.of((Tag[])new Tag[]{MetricsTags.getTenantTag((String)tenantId)});
        this.registry.find(METER_CONNECTIONS_AUTHENTICATED).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_CONNECTIONS_AUTHENTICATED_DURATION).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_MESSAGES_PAYLOAD).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_MESSAGES_RECEIVED).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_COMMANDS_PAYLOAD).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_COMMANDS_RECEIVED).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_DOWNSTREAM_FULL).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_DOWNSTREAM_SENT).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.registry.find(METER_DOWNSTREAM_TIMEOUT).tags((Iterable)tenantTag).meters().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.vertx.eventBus().publish("tenant.timeout", (Object)tenantId);
    }

    private void trackDeviceConnectionDuration(String tenantId, long deviceConnectionsCount) {
        this.connectionDurationTrackers.compute(tenantId, (tenant, deviceConnectionDurationTracker) -> Optional.ofNullable(deviceConnectionDurationTracker).map(tracker -> tracker.updateNoOfDeviceConnections(deviceConnectionsCount)).orElseGet(() -> {
            if (deviceConnectionsCount > 0L) {
                return DeviceConnectionDurationTracker.Builder.forTenant(tenant).withVertx(this.vertx).withNumberOfDeviceConnections(deviceConnectionsCount).withRecordingInterval(DEVICE_CONNECTION_DURATION_RECORDING_INTERVAL_IN_MS).recordUsing(connectionDuration -> this.registry.timer(METER_CONNECTIONS_AUTHENTICATED_DURATION, (Iterable)Tags.of((Tag[])new Tag[]{MetricsTags.getTenantTag((String)tenantId)})).record(connectionDuration.longValue(), TimeUnit.MILLISECONDS)).start();
            }
            return null;
        }));
    }

    public SendMessageSampler create(final String messageType) {
        Objects.requireNonNull(messageType);
        return new SendMessageSampler(){

            public SendMessageSampler.Sample start(final String tenantId) {
                final Timer.Sample sample = Timer.start((MeterRegistry)MicrometerBasedMetrics.this.registry);
                return new SendMessageSampler.Sample(){

                    public void completed(String outcome) {
                        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"type", (String)messageType), MetricsTags.getTenantTag((String)tenantId), Tag.of((String)"outcome", (String)outcome)});
                        sample.stop(MicrometerBasedMetrics.this.registry.timer(MicrometerBasedMetrics.METER_DOWNSTREAM_SENT, (Iterable)tags));
                    }

                    public void timeout() {
                        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"type", (String)messageType), MetricsTags.getTenantTag((String)tenantId)});
                        MicrometerBasedMetrics.this.registry.counter(MicrometerBasedMetrics.METER_DOWNSTREAM_TIMEOUT, (Iterable)tags).increment();
                    }
                };
            }

            public void queueFull(String tenantId) {
                Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"type", (String)messageType), MetricsTags.getTenantTag((String)tenantId)});
                MicrometerBasedMetrics.this.registry.counter(MicrometerBasedMetrics.METER_DOWNSTREAM_FULL, (Iterable)tags).increment();
            }
        };
    }
}

