/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.monitoring;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import org.eclipse.hono.adapter.monitoring.ConnectionEventProducer;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.util.RegistrationAssertion;

public abstract class AbstractMessageSenderConnectionEventProducer
implements ConnectionEventProducer {
    protected AbstractMessageSenderConnectionEventProducer() {
    }

    @Override
    public Future<?> connected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "connected", data);
    }

    @Override
    public Future<?> disconnected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "disconnected", data);
    }

    private Future<?> sendNotificationEvent(ConnectionEventProducer.Context context, Device authenticatedDevice, String protocolAdapter, String remoteId, String cause, JsonObject data) {
        if (authenticatedDevice == null) {
            return Future.succeededFuture();
        }
        String tenantId = authenticatedDevice.getTenantId();
        String deviceId = authenticatedDevice.getDeviceId();
        return context.getTenantClient().get(tenantId, null).compose(tenant -> {
            JsonObject payload = new JsonObject();
            payload.put("cause", cause);
            payload.put("remote-id", remoteId);
            payload.put("source", protocolAdapter);
            if (data != null) {
                payload.put("data", data);
            }
            return context.getMessageSenderClient().sendEvent(tenant, new RegistrationAssertion(deviceId), "application/vnd.eclipse-hono-dc-notification+json", payload.toBuffer(), null, null);
        });
    }
}

