/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.ext.web.client.WebClient;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.hono.adapter.resourcelimits.LimitedResource;
import org.eclipse.hono.adapter.resourcelimits.LimitedResourceKey;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedAsyncCacheLoader;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.ConnectionDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDurationAsyncCacheLoader
extends PrometheusBasedAsyncCacheLoader<LimitedResourceKey, LimitedResource<Duration>> {
    private static final String METRIC_NAME_CONNECTIONS_DURATION = String.format("%s_seconds_sum", "hono.connections.authenticated.duration".replace(".", "_"));
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionDurationAsyncCacheLoader.class);

    public ConnectionDurationAsyncCacheLoader(WebClient webClient, PrometheusBasedResourceLimitChecksConfig config, Tracer tracer) {
        super(webClient, config, tracer);
    }

    public CompletableFuture<LimitedResource<Duration>> asyncLoad(LimitedResourceKey key, Executor executor) {
        Span span = this.tracer.buildSpan("determine used connection duration").withTag((Tag)Tags.COMPONENT, (Object)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(TracingHelper.TAG_TENANT_ID.getKey(), key.getTenantId()).start();
        CompletableFuture result = new CompletableFuture();
        key.getTenantInformation(span.context()).onFailure(result::completeExceptionally).onSuccess(tenant -> {
            if (tenant.getResourceLimits() == null) {
                span.log(Map.of("message", "no resource limits configured"));
                LOG.trace("no resource limits configured for tenant [{}]", (Object)tenant.getTenantId());
                result.complete(new LimitedResource<Duration>(null, Duration.ZERO));
            } else if (tenant.getResourceLimits().getConnectionDuration() == null) {
                span.log(Map.of("message", "no connection duration limit configured"));
                LOG.trace("no connection duration limit configured for tenant [{}]", (Object)tenant.getTenantId());
                result.complete(new LimitedResource<Duration>(null, Duration.ZERO));
            } else {
                ConnectionDuration connectionDuration = tenant.getResourceLimits().getConnectionDuration();
                LOG.trace("connection duration config for tenant [{}] is [{}:{}, {}:{}, {}:{}, {}:{}]", new Object[]{tenant.getTenantId(), "max-minutes", connectionDuration.getMaxMinutes(), "effective-since", connectionDuration.getEffectiveSince(), "mode", connectionDuration.getPeriod().getMode(), "no-of-days", connectionDuration.getPeriod().getNoOfDays()});
                if (connectionDuration.isLimited()) {
                    Instant nowUtc = Instant.now(this.clock);
                    Duration connectionDurationUsagePeriod = connectionDuration.getElapsedAccountingPeriodDuration(nowUtc);
                    Duration allowedMaxDuration = Duration.ofMinutes(this.calculateEffectiveLimit(connectionDuration.getEffectiveSince(), nowUtc, connectionDuration.getPeriod().getMode(), connectionDuration.getMaxMinutes()));
                    if (connectionDurationUsagePeriod.toMinutes() <= 0L) {
                        result.complete(new LimitedResource<Duration>(allowedMaxDuration, Duration.ZERO));
                    } else {
                        String query = String.format("minute( sum( increase( %s {tenant=\"%s\"} [%dm])))", METRIC_NAME_CONNECTIONS_DURATION, key.getTenantId(), connectionDurationUsagePeriod.toMinutes());
                        this.executeQuery(query, span.context()).onSuccess(minutesConnected -> result.complete(new LimitedResource<Duration>(allowedMaxDuration, Duration.ofMinutes(minutesConnected)))).onFailure(result::completeExceptionally);
                    }
                } else {
                    span.log(Map.of("message", "connection duration is unlimited"));
                    LOG.trace("connection duration is unlimited for tenant [{}]", (Object)tenant.getTenantId());
                    result.complete(new LimitedResource<Duration>(null, Duration.ZERO));
                }
            }
        });
        return result.whenComplete((duration, error) -> span.finish());
    }
}

