/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device;

import io.opentracing.Tracer;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.adapter.auth.device.UsernamePasswordCredentials;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.auth.SpringBasedHonoPasswordEncoder;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.util.CredentialsObject;
import org.eclipse.hono.util.JsonHelper;
import org.springframework.beans.factory.annotation.Autowired;

public final class UsernamePasswordAuthProvider
extends CredentialsApiAuthProvider<UsernamePasswordCredentials> {
    private final HonoPasswordEncoder pwdEncoder;

    @Autowired
    public UsernamePasswordAuthProvider(CredentialsClient credentialsClient, Tracer tracer) {
        this(credentialsClient, (HonoPasswordEncoder)new SpringBasedHonoPasswordEncoder(), tracer);
    }

    @Autowired
    public UsernamePasswordAuthProvider(CredentialsClient credentialsClient, HonoPasswordEncoder pwdEncoder, Tracer tracer) {
        super(credentialsClient, tracer);
        this.pwdEncoder = Objects.requireNonNull(pwdEncoder);
    }

    @Override
    public UsernamePasswordCredentials getCredentials(JsonObject authInfo) {
        String username = (String)JsonHelper.getValue((JsonObject)authInfo, (String)"username", String.class, null);
        String password = (String)JsonHelper.getValue((JsonObject)authInfo, (String)"password", String.class, null);
        if (username == null || password == null) {
            return null;
        }
        JsonObject clientContext = authInfo.copy();
        clientContext.remove("username");
        clientContext.remove("password");
        if (password.isEmpty()) {
            return this.tryGetCredentialsEncodedInUsername(username, clientContext);
        }
        return UsernamePasswordCredentials.create(username, password, clientContext);
    }

    private UsernamePasswordCredentials tryGetCredentialsEncodedInUsername(String username, JsonObject clientContext) {
        try {
            String decoded = new String(Base64.getDecoder().decode(username));
            int colonIdx = decoded.indexOf(":");
            if (colonIdx > -1) {
                String user = decoded.substring(0, colonIdx);
                String pass = decoded.substring(colonIdx + 1);
                return UsernamePasswordCredentials.create(user, pass, clientContext);
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            this.log.debug("error extracting username/password from username field", (Throwable)ex);
            return null;
        }
    }

    @Override
    protected Future<Device> doValidateCredentials(UsernamePasswordCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("not running on vert.x Context"));
        }
        Promise result = Promise.promise();
        currentContext.executeBlocking(blockingCodeHandler -> {
            this.log.debug("validating password hash on vert.x worker thread [{}]", (Object)Thread.currentThread().getName());
            boolean isValid = credentialsOnRecord.getCandidateSecrets().stream().anyMatch(candidateSecret -> this.pwdEncoder.matches(deviceCredentials.getPassword(), candidateSecret));
            if (isValid) {
                blockingCodeHandler.complete((Object)new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()));
            } else {
                blockingCodeHandler.fail((Throwable)new ClientErrorException(401, "bad credentials"));
            }
        }, false, (Handler)result);
        return result.future();
    }
}

