/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.amqp;

import org.eclipse.hono.adapter.ProtocolAdapterProperties;
import org.eclipse.hono.adapter.amqp.AmqpAdapterOptions;

public class AmqpAdapterProperties
extends ProtocolAdapterProperties {
    public static final int DEFAULT_MAX_FRAME_SIZE_BYTES = 16384;
    public static final int DEFAULT_MAX_SESSION_FRAMES = 30;
    public static final int DEFAULT_IDLE_TIMEOUT_MILLIS = 60000;
    public static final long DEFAULT_SEND_MESSAGE_TO_DEVICE_TIMEOUT = 1000L;
    private int maxFrameSize = 16384;
    private int maxSessionFrames = 30;
    private int idleTimeout = 60000;
    private long sendMessageToDeviceTimeout = 1000L;

    public AmqpAdapterProperties() {
    }

    public AmqpAdapterProperties(AmqpAdapterOptions options) {
        super(options.adapterOptions());
        this.setIdleTimeout(options.idleTimeout());
        this.setMaxFrameSize(options.maxFrameSize());
        this.setMaxSessionFrames(options.maxSessionFrames());
        this.setSendMessageToDeviceTimeout(options.sendMessageToDeviceTimeout());
    }

    public final int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public final void setMaxFrameSize(int maxFrameSize) {
        if (maxFrameSize < 512) {
            throw new IllegalArgumentException("frame size must be at least 512 bytes");
        }
        this.maxFrameSize = maxFrameSize;
    }

    public final int getMaxSessionFrames() {
        return this.maxSessionFrames;
    }

    public final void setMaxSessionFrames(int maxSessionFrames) {
        if (maxSessionFrames < 1) {
            throw new IllegalArgumentException("must support at least one frame being in flight");
        }
        this.maxSessionFrames = maxSessionFrames;
    }

    public final int getMaxSessionWindowSize() {
        return this.maxSessionFrames * this.maxFrameSize;
    }

    public final void setIdleTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("idle timeout period must be >= 0");
        }
        this.idleTimeout = timeout;
    }

    public final int getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getSendMessageToDeviceTimeout() {
        return this.sendMessageToDeviceTimeout;
    }

    public final void setSendMessageToDeviceTimeout(long sendMessageToDeviceTimeout) {
        if (sendMessageToDeviceTimeout < 0L) {
            throw new IllegalArgumentException("timeout value must be >= 0");
        }
        this.sendMessageToDeviceTimeout = sendMessageToDeviceTimeout;
    }
}

