/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.amqp;

import io.opentracing.Span;
import io.vertx.proton.ProtonConnection;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.hono.service.auth.SniExtensionHelper;
import org.eclipse.hono.util.MapBasedExecutionContext;

public final class SaslResponseContext
extends MapBasedExecutionContext {
    private final ProtonConnection protonConnection;
    private final Certificate[] clientCertificateChain;
    private final String[] saslResponseFields;
    private final String remoteMechanism;
    private final List<String> requestedHostNames;

    private SaslResponseContext(ProtonConnection protonConnection, String remoteMechanism, Span span, String[] saslResponseFields, Certificate[] clientCertificateChain, List<String> requestedHostNames) {
        super(span);
        this.protonConnection = Objects.requireNonNull(protonConnection);
        this.remoteMechanism = Objects.requireNonNull(remoteMechanism);
        this.saslResponseFields = saslResponseFields;
        this.clientCertificateChain = clientCertificateChain;
        this.requestedHostNames = requestedHostNames;
    }

    public static SaslResponseContext forMechanismPlain(ProtonConnection protonConnection, String[] saslResponseFields, Span span, SSLSession tlsSession) {
        Objects.requireNonNull(protonConnection);
        Objects.requireNonNull(saslResponseFields);
        Objects.requireNonNull(span);
        List hostNames = Optional.ofNullable(tlsSession).map(SniExtensionHelper::getHostNames).orElse(null);
        return new SaslResponseContext(protonConnection, "PLAIN", span, saslResponseFields, null, hostNames);
    }

    public static SaslResponseContext forMechanismExternal(ProtonConnection protonConnection, Span span, SSLSession tlsSession) throws SSLPeerUnverifiedException {
        Objects.requireNonNull(protonConnection);
        Objects.requireNonNull(span);
        Objects.requireNonNull(tlsSession);
        Certificate[] certChain = tlsSession.getPeerCertificates();
        List hostNames = SniExtensionHelper.getHostNames((SSLSession)tlsSession);
        return new SaslResponseContext(protonConnection, "EXTERNAL", span, null, certChain, hostNames);
    }

    public Certificate[] getPeerCertificateChain() {
        return this.clientCertificateChain;
    }

    public String[] getSaslResponseFields() {
        return this.saslResponseFields;
    }

    public String getRemoteMechanism() {
        return this.remoteMechanism;
    }

    public ProtonConnection getProtonConnection() {
        return this.protonConnection;
    }

    public List<String> getRequestedHostNames() {
        return this.requestedHostNames;
    }
}

