/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.deviceconnection.infinispan.client.BasicCache;
import org.eclipse.hono.deviceconnection.infinispan.client.CommonCacheConfig;
import org.eclipse.hono.deviceconnection.infinispan.client.InfinispanRemoteConfigurationProperties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HotrodCache<K, V>
extends BasicCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(HotrodCache.class);
    private static final Duration CACHED_CONNECTION_CHECK_RESULT_MAX_AGE = Duration.ofSeconds(30L);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final RemoteCacheContainer cacheManager;
    private final String cacheName;
    private final K connectionCheckKey;
    private final V connectionCheckValue;
    private ConnectionCheckResult lastConnectionCheckResult;

    HotrodCache(Vertx vertx, RemoteCacheContainer cacheManager, String cacheName, K connectionCheckKey, V connectionCheckValue) {
        super(vertx, (BasicCacheContainer)cacheManager);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.cacheName = Objects.requireNonNull(cacheName);
        this.connectionCheckKey = Objects.requireNonNull(connectionCheckKey);
        this.connectionCheckValue = Objects.requireNonNull(connectionCheckValue);
    }

    public static HotrodCache<String, String> from(Vertx vertx, InfinispanRemoteConfigurationProperties properties, CommonCacheConfig commonCacheConfig) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(properties);
        Objects.requireNonNull(commonCacheConfig);
        ConfigurationBuilder configBuilder = properties.getConfigurationBuilder();
        configBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        configBuilder.remoteCache(commonCacheConfig.getCacheName()).forceReturnValues(true);
        Configuration configuration = configBuilder.build();
        LOG.info("creating HotrodCache using configuration: {}", (Object)configuration);
        return new HotrodCache<String, String>(vertx, (RemoteCacheContainer)new RemoteCacheManager(configuration, false), commonCacheConfig.getCacheName(), commonCacheConfig.getCheckKey(), commonCacheConfig.getCheckValue());
    }

    @Override
    protected Future<Void> connectToCache() {
        Promise result = Promise.promise();
        if (this.connecting.compareAndSet(false, true)) {
            this.vertx.executeBlocking(r -> {
                try {
                    if (!this.cacheManager.isStarted()) {
                        LOG.debug("trying to start cache manager");
                        this.cacheManager.start();
                        LOG.info("started cache manager, now connecting to remote cache");
                    }
                    LOG.debug("trying to connect to remote cache");
                    RemoteCache cache = this.cacheManager.getCache(this.cacheName);
                    if (cache == null) {
                        r.fail((Throwable)new IllegalStateException("remote cache [" + this.cacheName + "] does not exist"));
                    } else {
                        cache.start();
                        this.setCache(cache);
                        r.complete((Object)cache);
                    }
                }
                catch (Throwable t) {
                    r.fail(t);
                }
            }, attempt -> {
                if (attempt.succeeded()) {
                    LOG.info("successfully connected to remote cache");
                    result.complete();
                } else {
                    LOG.debug("failed to connect to remote cache: {}", (Object)attempt.cause().getMessage());
                    result.fail(attempt.cause());
                }
                this.connecting.set(false);
            });
        } else {
            LOG.info("already trying to establish connection to data grid");
            result.fail("already trying to establish connection to data grid");
        }
        return result.future();
    }

    @Override
    protected boolean isStarted() {
        return this.cacheManager.isStarted() && this.getCache() != null;
    }

    @Override
    public Future<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(cache -> {
            RemoteCache remoteCache = (RemoteCache)cache;
            return remoteCache.getWithMetadataAsync(key).thenCompose(metadataValue -> {
                if (metadataValue != null && value.equals(metadataValue.getValue())) {
                    return remoteCache.removeWithVersionAsync(key, metadataValue.getVersion());
                }
                return CompletableFuture.completedFuture(Boolean.FALSE);
            });
        });
    }

    @Override
    protected <T> void postCacheAccess(AsyncResult<T> cacheOperationResult) {
        this.lastConnectionCheckResult = new ConnectionCheckResult(cacheOperationResult.cause());
    }

    @Override
    public Future<JsonObject> checkForCacheAvailability() {
        if (this.isStarted()) {
            ConnectionCheckResult lastResult = this.lastConnectionCheckResult;
            if (lastResult != null && !lastResult.isOlderThan(CACHED_CONNECTION_CHECK_RESULT_MAX_AGE)) {
                return lastResult.asFuture();
            }
            Promise result = Promise.promise();
            this.put(this.connectionCheckKey, this.connectionCheckValue).onComplete(r -> {
                if (r.succeeded()) {
                    result.complete((Object)new JsonObject());
                } else {
                    LOG.debug("failed to put test value to cache", r.cause());
                    result.fail(r.cause());
                }
            });
            return result.future();
        }
        this.connectToCache();
        return Future.failedFuture((String)"not connected to data grid");
    }

    private static class ConnectionCheckResult {
        private final Instant creationTimestamp = Instant.now();
        private final Throwable errorResult;

        ConnectionCheckResult(Throwable errorResult) {
            this.errorResult = errorResult;
        }

        public boolean isOlderThan(Duration timespan) {
            return this.creationTimestamp.isBefore(Instant.now().minus(timespan));
        }

        public Future<JsonObject> asFuture() {
            return this.errorResult != null ? Future.failedFuture((Throwable)this.errorResult) : Future.succeededFuture((Object)new JsonObject());
        }
    }
}

