/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import java.util.Optional;
import org.eclipse.hono.adapter.client.command.DeviceConnectionClient;
import org.eclipse.hono.deviceconnection.infinispan.client.CacheBasedDeviceConnectionClient;
import org.eclipse.hono.deviceconnection.infinispan.client.CacheBasedDeviceConnectionInfo;
import org.eclipse.hono.deviceconnection.infinispan.client.CommonCacheConfig;
import org.eclipse.hono.deviceconnection.infinispan.client.HotrodCache;
import org.eclipse.hono.deviceconnection.infinispan.client.InfinispanRemoteConfigurationProperties;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HotrodCacheConfig {
    @Bean
    @ConfigurationProperties(prefix="hono.device-connection")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"server-list"})
    public InfinispanRemoteConfigurationProperties remoteCacheProperties() {
        return new InfinispanRemoteConfigurationProperties();
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.device-connection", name={"server-list"})
    public RemoteCacheManager remoteCacheManager() {
        InfinispanRemoteConfigurationProperties properties = this.remoteCacheProperties();
        return new RemoteCacheManager(properties.getConfigurationBuilder().build(), false);
    }

    @Bean
    @ConditionalOnProperty(prefix="hono.device-connection", name={"server-list"})
    public HotrodCache<String, String> remoteCache(Vertx vertx, CommonCacheConfig cacheConfig) {
        return new HotrodCache<String, String>(vertx, (RemoteCacheContainer)this.remoteCacheManager(), cacheConfig.getCacheName(), cacheConfig.getCheckKey(), cacheConfig.getCheckValue());
    }

    @Bean
    @Qualifier(value="device_con")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"server-list"})
    public DeviceConnectionClient hotrodBasedDeviceConnectionClient(HotrodCache<String, String> cache, Optional<Tracer> tracer) {
        Tracer effectiveTracer = tracer.orElse((Tracer)NoopTracerFactory.create());
        return new CacheBasedDeviceConnectionClient(new CacheBasedDeviceConnectionInfo(cache, effectiveTracer), effectiveTracer);
    }

    @Bean
    @ConfigurationProperties(prefix="hono.device-connection.common")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"server-list"})
    public CommonCacheConfig commonCacheConfig() {
        return new CommonCacheConfig();
    }
}

