/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.hono.client.ConnectionLifecycle;
import org.eclipse.hono.client.DisconnectListener;
import org.eclipse.hono.client.ReconnectListener;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.deviceconnection.infinispan.client.Cache;
import org.eclipse.hono.util.Futures;
import org.infinispan.commons.api.BasicCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicCache<K, V>
implements Cache<K, V>,
ConnectionLifecycle<BasicCache<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCache.class);
    protected final Vertx vertx;
    private final BasicCacheContainer cacheManager;
    private final K connectionCheckKey;
    private final V connectionCheckValue;
    private org.infinispan.commons.api.BasicCache<K, V> cache;

    public BasicCache(Vertx vertx, BasicCacheContainer cacheManager, K connectionCheckKey, V connectionCheckValue) {
        this.vertx = Objects.requireNonNull(vertx);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.connectionCheckKey = Objects.requireNonNull(connectionCheckKey);
        this.connectionCheckValue = Objects.requireNonNull(connectionCheckValue);
    }

    protected abstract Future<Void> connectToGrid();

    protected abstract boolean isStarted();

    public Future<BasicCache<K, V>> connect() {
        return this.connectToGrid().map(ok -> this);
    }

    public Future<Void> isConnected() {
        return this.checkForCacheAvailability().mapEmpty();
    }

    public void disconnect() {
        this.disconnect((Handler<AsyncResult<Void>>)((Handler)r -> {}));
    }

    public void disconnect(Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking(r -> {
            try {
                this.cacheManager.stop();
                r.complete();
            }
            catch (Throwable t) {
                r.fail(t);
            }
        }, stopAttempt -> {
            if (stopAttempt.succeeded()) {
                LOG.info("connection(s) to cache stopped successfully");
            } else {
                LOG.info("error trying to stop connection(s) to cache", stopAttempt.cause());
            }
            completionHandler.handle(stopAttempt);
        });
    }

    public void addDisconnectListener(DisconnectListener<BasicCache<K, V>> listener) {
    }

    public void addReconnectListener(ReconnectListener<BasicCache<K, V>> listener) {
    }

    protected void setCache(org.infinispan.commons.api.BasicCache<K, V> cache) {
        this.cache = cache;
    }

    protected org.infinispan.commons.api.BasicCache<K, V> getCache() {
        return this.cache;
    }

    protected <T> Future<T> withCache(Function<org.infinispan.commons.api.BasicCache<K, V>, CompletionStage<T>> futureSupplier) {
        org.infinispan.commons.api.BasicCache cache = this.cache;
        if (cache == null) {
            return BasicCache.noConnectionFailure();
        }
        return Futures.create(() -> (CompletionStage)futureSupplier.apply(cache));
    }

    @Override
    public Future<V> put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(cache -> cache.putAsync(key, value));
    }

    @Override
    public Future<V> put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(lifespanUnit);
        return this.withCache(cache -> cache.putAsync(key, value, lifespan, lifespanUnit));
    }

    @Override
    public Future<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(cache -> cache.removeAsync(key, value));
    }

    @Override
    public Future<V> get(K key) {
        Objects.requireNonNull(key);
        return this.withCache(cache -> cache.getAsync(key));
    }

    @Override
    public Future<Map<K, V>> getAll(Set<? extends K> keys) {
        Objects.requireNonNull(keys);
        return this.withCache(cache -> cache.getAllAsync(keys));
    }

    private static <V> Future<V> noConnectionFailure() {
        return Future.failedFuture((Throwable)new ServerErrorException(503, "no connection to data grid"));
    }

    @Override
    public Future<JsonObject> checkForCacheAvailability() {
        Promise result = Promise.promise();
        if (this.isStarted()) {
            Instant start = Instant.now();
            this.put(this.connectionCheckKey, this.connectionCheckValue).onComplete(r -> {
                if (r.succeeded()) {
                    long requestDuration = Duration.between(start, Instant.now()).toMillis();
                    result.complete((Object)new JsonObject().put("grid-response-time", Long.valueOf(requestDuration)));
                } else {
                    LOG.debug("failed to put test value to cache", r.cause());
                    result.fail(r.cause());
                }
            });
        } else {
            this.connectToGrid();
            result.fail("not connected to data grid");
        }
        return result.future();
    }
}

