/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.Objects;
import org.eclipse.hono.client.BasicDeviceConnectionClientFactory;
import org.eclipse.hono.client.ConnectionLifecycle;
import org.eclipse.hono.client.DeviceConnectionClient;
import org.eclipse.hono.client.DisconnectListener;
import org.eclipse.hono.client.ReconnectListener;
import org.eclipse.hono.deviceconnection.infinispan.client.HotrodBasedDeviceConnectionClient;
import org.eclipse.hono.deviceconnection.infinispan.client.HotrodBasedDeviceConnectionInfo;
import org.eclipse.hono.deviceconnection.infinispan.client.HotrodCache;

public final class HotrodBasedDeviceConnectionClientFactory
implements BasicDeviceConnectionClientFactory,
ConnectionLifecycle<HotrodCache<String, String>> {
    private final Cache<String, HotrodBasedDeviceConnectionClient> clients = Caffeine.newBuilder().maximumSize(100L).build();
    private final HotrodCache<String, String> cache;
    private final Tracer tracer;

    public HotrodBasedDeviceConnectionClientFactory(HotrodCache<String, String> cache, Tracer tracer) {
        this.cache = Objects.requireNonNull(cache);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public Future<HotrodCache<String, String>> connect() {
        return this.cache.connect();
    }

    public void addDisconnectListener(DisconnectListener<HotrodCache<String, String>> listener) {
        this.cache.addDisconnectListener(listener);
    }

    public void addReconnectListener(ReconnectListener<HotrodCache<String, String>> listener) {
        this.cache.addReconnectListener(listener);
    }

    public Future<Void> isConnected() {
        return this.cache.isConnected();
    }

    public void disconnect() {
        this.cache.disconnect();
    }

    public void disconnect(Handler<AsyncResult<Void>> completionHandler) {
        this.cache.disconnect(completionHandler);
    }

    public Future<DeviceConnectionClient> getOrCreateDeviceConnectionClient(String tenantId) {
        DeviceConnectionClient result = (DeviceConnectionClient)this.clients.get((Object)tenantId, key -> {
            HotrodBasedDeviceConnectionInfo info = new HotrodBasedDeviceConnectionInfo(this.cache, this.tracer);
            return new HotrodBasedDeviceConnectionClient((String)key, info, this.tracer);
        });
        return Future.succeededFuture((Object)result);
    }
}

