/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.DeviceConnectionClient;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;
import org.eclipse.hono.tracing.TracingHelper;

public final class HotrodBasedDeviceConnectionClient
implements DeviceConnectionClient {
    private static final String SPAN_NAME_GET_LAST_GATEWAY = "get last known gateway";
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES = "get command handling adapter instances";
    private static final String SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE = "set command handling adapter instance";
    private static final String SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE = "remove command handling adapter instance";
    final String tenantId;
    final DeviceConnectionInfo cache;
    private final Tracer tracer;

    public HotrodBasedDeviceConnectionClient(String tenantId, DeviceConnectionInfo cache, Tracer tracer) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.cache = Objects.requireNonNull(cache);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public void close(Handler<AsyncResult<Void>> closeHandler) {
        closeHandler.handle((Object)Future.succeededFuture());
    }

    public boolean isOpen() {
        return true;
    }

    public void setRequestTimeout(long timoutMillis) {
    }

    public int getCredit() {
        return 1;
    }

    public void sendQueueDrainHandler(Handler<Void> handler) {
        handler.handle(null);
    }

    public Future<Void> setLastKnownGatewayForDevice(String deviceId, String gatewayId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_SET_LAST_GATEWAY);
        TracingHelper.setDeviceTags((Span)span, (String)this.tenantId, (String)deviceId);
        TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
        return this.finishSpan(this.cache.setLastKnownGatewayForDevice(this.tenantId, deviceId, gatewayId, span.context()), span);
    }

    public Future<JsonObject> getLastKnownGatewayForDevice(String deviceId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_GET_LAST_GATEWAY);
        TracingHelper.setDeviceTags((Span)span, (String)this.tenantId, (String)deviceId);
        return this.finishSpan(this.cache.getLastKnownGatewayForDevice(this.tenantId, deviceId, span.context()), span);
    }

    public Future<Void> setCommandHandlingAdapterInstance(String deviceId, String adapterInstanceId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE);
        TracingHelper.setDeviceTags((Span)span, (String)this.tenantId, (String)deviceId);
        span.setTag("adapter_instance_id", adapterInstanceId);
        return this.finishSpan(this.cache.setCommandHandlingAdapterInstance(this.tenantId, deviceId, adapterInstanceId, span.context()), span);
    }

    public Future<Void> removeCommandHandlingAdapterInstance(String deviceId, String adapterInstanceId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE);
        TracingHelper.setDeviceTags((Span)span, (String)this.tenantId, (String)deviceId);
        span.setTag("adapter_instance_id", adapterInstanceId);
        return this.finishSpan(this.cache.removeCommandHandlingAdapterInstance(this.tenantId, deviceId, adapterInstanceId, span.context()), span);
    }

    public Future<JsonObject> getCommandHandlingAdapterInstances(String deviceId, List<String> viaGateways, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES);
        TracingHelper.setDeviceTags((Span)span, (String)this.tenantId, (String)deviceId);
        return this.finishSpan(this.cache.getCommandHandlingAdapterInstances(this.tenantId, deviceId, new HashSet<String>(viaGateways), span.context()), span);
    }

    private Span newSpan(SpanContext parent, String operationName) {
        return TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)parent, (String)operationName, (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").start();
    }

    private <T> Future<T> finishSpan(Future<T> result, Span span) {
        return result.recover(t -> {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(ServiceInvocationException.extractStatusCode((Throwable)t)));
            TracingHelper.logError((Span)span, (Throwable)t);
            span.finish();
            return Future.failedFuture((Throwable)t);
        }).map(resultValue -> {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(resultValue != null ? 200 : 202));
            span.finish();
            return resultValue;
        });
    }
}

