/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.DeviceConnectionClient;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Lifecycle;

public final class CacheBasedDeviceConnectionClient
implements DeviceConnectionClient,
ServiceClient {
    private static final String SPAN_NAME_GET_LAST_GATEWAY = "get last known gateway";
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES = "get command handling adapter instances";
    private static final String SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE = "set command handling adapter instance";
    private static final String SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE = "remove command handling adapter instance";
    private final DeviceConnectionInfo connectionInfoCache;
    private final Tracer tracer;

    public CacheBasedDeviceConnectionClient(DeviceConnectionInfo cache, Tracer tracer) {
        this.connectionInfoCache = Objects.requireNonNull(cache);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public Future<Void> setLastKnownGatewayForDevice(String tenantId, String deviceId, String gatewayId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_SET_LAST_GATEWAY);
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
        TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
        return this.finishSpan(this.connectionInfoCache.setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, span), span);
    }

    public Future<JsonObject> getLastKnownGatewayForDevice(String tenantId, String deviceId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_GET_LAST_GATEWAY);
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
        return this.finishSpan(this.connectionInfoCache.getLastKnownGatewayForDevice(tenantId, deviceId, span), span);
    }

    public Future<Void> setCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Duration lifespan, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE);
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
        span.setTag("adapter_instance_id", adapterInstanceId);
        int lifespanSeconds = lifespan != null && lifespan.getSeconds() <= Integer.MAX_VALUE ? (int)lifespan.getSeconds() : -1;
        span.setTag("lifespan", (Number)lifespanSeconds);
        return this.finishSpan(this.connectionInfoCache.setCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, lifespan, span), span);
    }

    public Future<Void> removeCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE);
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
        span.setTag("adapter_instance_id", adapterInstanceId);
        return this.finishSpan(this.connectionInfoCache.removeCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, span), span, 412);
    }

    public Future<JsonObject> getCommandHandlingAdapterInstances(String tenantId, String deviceId, List<String> viaGateways, SpanContext context) {
        Span span = this.newSpan(context, SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES);
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
        return this.finishSpan(this.connectionInfoCache.getCommandHandlingAdapterInstances(tenantId, deviceId, new HashSet<String>(viaGateways), span), span);
    }

    private Span newSpan(SpanContext parent, String operationName) {
        return TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)parent, (String)operationName, (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").start();
    }

    private <T> Future<T> finishSpan(Future<T> result, Span span) {
        return this.finishSpan(result, span, null);
    }

    private <T> Future<T> finishSpan(Future<T> result, Span span, Integer statusToSkipErrorTraceFor) {
        return result.recover(t -> {
            int statusCode = ServiceInvocationException.extractStatusCode((Throwable)t);
            Tags.HTTP_STATUS.set(span, Integer.valueOf(statusCode));
            if (statusToSkipErrorTraceFor == null || statusCode != statusToSkipErrorTraceFor) {
                TracingHelper.logError((Span)span, (Throwable)t);
            }
            span.finish();
            return Future.failedFuture((Throwable)t);
        }).map(resultValue -> {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(resultValue != null ? 200 : 204));
            span.finish();
            return resultValue;
        });
    }

    public Future<Void> start() {
        if (this.connectionInfoCache instanceof Lifecycle) {
            return ((Lifecycle)this.connectionInfoCache).stop();
        }
        return Future.succeededFuture();
    }

    public Future<Void> stop() {
        if (this.connectionInfoCache instanceof Lifecycle) {
            return ((Lifecycle)this.connectionInfoCache).stop();
        }
        return Future.succeededFuture();
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        if (this.connectionInfoCache instanceof ServiceClient) {
            ((ServiceClient)this.connectionInfoCache).registerReadinessChecks(readinessHandler);
        }
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
        if (this.connectionInfoCache instanceof ServiceClient) {
            ((ServiceClient)this.connectionInfoCache).registerLivenessChecks(livenessHandler);
        }
    }
}

