/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.factory.primitive.BooleanBags;
import org.eclipse.collections.api.factory.primitive.BooleanLists;
import org.eclipse.collections.api.factory.primitive.BooleanSets;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;

public class ReverseBooleanIterable
extends AbstractLazyBooleanIterable {
    private final BooleanList adapted;

    public ReverseBooleanIterable(BooleanList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseBooleanIterable adapt(BooleanList booleanList) {
        return new ReverseBooleanIterable(booleanList);
    }

    public BooleanIterator booleanIterator() {
        return new ReverseBooleanIterator();
    }

    public void each(BooleanProcedure procedure) {
        BooleanIterator iterator = this.booleanIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public boolean[] toArray() {
        boolean[] results = new boolean[this.adapted.size()];
        int index = 0;
        BooleanIterator iterator = this.booleanIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(boolean value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanLists.mutable.withAll((BooleanIterable)this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanSets.mutable.withAll((BooleanIterable)this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanBags.mutable.withAll((BooleanIterable)this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    private class ReverseBooleanIterator
    implements BooleanIterator {
        private int currentIndex;

        private ReverseBooleanIterator() {
            this.currentIndex = ReverseBooleanIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            boolean next = ReverseBooleanIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

