/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.collections.impl.test.Verify;

public final class SerializeTestHelper {
    private SerializeTestHelper() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> T serializeDeserialize(T sourceObject) {
        byte[] pileOfBytes = SerializeTestHelper.serialize(sourceObject);
        return (T)SerializeTestHelper.deserialize(pileOfBytes);
    }

    public static <T> byte[] serialize(T sourceObject) {
        ByteArrayOutputStream baos = SerializeTestHelper.getByteArrayOutputStream(sourceObject);
        return baos.toByteArray();
    }

    public static <T> ByteArrayOutputStream getByteArrayOutputStream(T sourceObject) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SerializeTestHelper.writeObjectToStream(sourceObject, baos);
        }
        catch (IOException e) {
            Verify.fail("Failed to marshal an object", e);
        }
        return baos;
    }

    private static <T> void writeObjectToStream(Object sourceObject, ByteArrayOutputStream baos) throws IOException {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);){
            objectOutputStream.writeObject(sourceObject);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
    }

    private static Object readOneObject(ByteArrayInputStream bais) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectStream = new ObjectInputStream(bais);){
            Object object = objectStream.readObject();
            return object;
        }
    }

    public static Object deserialize(byte[] pileOfBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pileOfBytes);
        try {
            return SerializeTestHelper.readOneObject(bais);
        }
        catch (IOException | ClassNotFoundException e) {
            Verify.fail("Failed to unmarshal an object", e);
            return null;
        }
    }
}

