/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.test;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.SortedSets;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Triplet;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.StringIterate;

public class ClassComparer {
    private static final String SYMMETRIC_DIFFERENCE = "Symmetric Difference";
    private static final String INTERSECTION = "Intersection";
    private static final String DIFFERENCE = "Difference";
    private final boolean includeParameterTypesInMethods;
    private final boolean includeReturnTypes;
    private final boolean includePackageNames;
    private boolean includeObjectMethods = false;
    private final Appendable appendable;

    public ClassComparer() {
        this(false, false, false);
    }

    public ClassComparer(Appendable out) {
        this(out, false, false, false);
    }

    public ClassComparer(boolean includeParameterTypesInMethods, boolean includeReturnTypes, boolean includePackageNames) {
        this(System.out, includeParameterTypesInMethods, includeReturnTypes, includePackageNames);
    }

    public ClassComparer(Appendable out, boolean includeParameterTypesInMethods, boolean includeReturnTypes, boolean includePackageNames) {
        this.includeParameterTypesInMethods = includeParameterTypesInMethods;
        this.includeReturnTypes = includeReturnTypes;
        this.includePackageNames = includePackageNames;
        this.appendable = out;
    }

    public static boolean isProperSupersetOf(Class<?> supersetClass, Class<?> subsetClass) {
        return ClassComparer.isProperSubsetOf(subsetClass, supersetClass);
    }

    public static boolean isProperSubsetOf(Class<?> subsetClass, Class<?> supersetClass) {
        ClassComparer comparer = new ClassComparer(true, true, true);
        return comparer.getMethodNames(subsetClass).isProperSubsetOf(comparer.getMethodNames(supersetClass));
    }

    public Triplet<MutableSortedSet<String>> compare(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> intersection = this.intersect(leftClass, rightClass);
        MutableSortedSet<String> differenceLeft = this.difference(leftClass, rightClass);
        MutableSortedSet<String> differenceRight = this.difference(rightClass, leftClass);
        return Tuples.triplet(intersection, differenceLeft, differenceRight);
    }

    public MutableSortedSet<String> difference(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> leftMethods = this.getMethodNames(leftClass);
        MutableSortedSet<String> rightMethods = this.getMethodNames(rightClass);
        return leftMethods.difference(rightMethods);
    }

    public MutableSortedSet<String> printDifference(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> difference = this.difference(leftClass, rightClass);
        this.output((Twin<Class<?>>)Tuples.twin(leftClass, rightClass), DIFFERENCE, (RichIterable<String>)difference);
        return difference;
    }

    public MutableSortedSet<String> symmetricDifference(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> leftMethods = this.getMethodNames(leftClass);
        MutableSortedSet<String> rightMethods = this.getMethodNames(rightClass);
        return leftMethods.symmetricDifference(rightMethods);
    }

    public MutableSortedSet<String> printSymmetricDifference(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> symmetricDifference = this.symmetricDifference(leftClass, rightClass);
        this.output((Twin<Class<?>>)Tuples.twin(leftClass, rightClass), SYMMETRIC_DIFFERENCE, (RichIterable<String>)symmetricDifference);
        return symmetricDifference;
    }

    public MutableSortedSet<String> intersect(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> leftMethods = this.getMethodNames(leftClass);
        MutableSortedSet<String> rightMethods = this.getMethodNames(rightClass);
        return leftMethods.intersect(rightMethods);
    }

    public MutableSortedSet<String> printIntersection(Class<?> leftClass, Class<?> rightClass) {
        MutableSortedSet<String> intersect = this.intersect(leftClass, rightClass);
        this.output((Twin<Class<?>>)Tuples.twin(leftClass, rightClass), INTERSECTION, (RichIterable<String>)intersect);
        return intersect;
    }

    public MutableSortedSet<String> printClass(Class<?> clazz) {
        MutableSortedSet<String> methodNames = this.getMethodNames(clazz);
        this.outputTitle("Class: " + (this.includePackageNames ? clazz.getName() : clazz.getSimpleName()));
        this.outputGroupByToString((RichIterable<String>)methodNames);
        return methodNames;
    }

    public Triplet<MutableSortedSet<String>> compareAndPrint(Class<?> leftClass, Class<?> rightClass) {
        Triplet<MutableSortedSet<String>> compare = this.compare(leftClass, rightClass);
        Twin classPair = Tuples.twin(leftClass, rightClass);
        this.output(classPair, INTERSECTION, (RichIterable<String>)((RichIterable)compare.getOne()));
        this.output(classPair, DIFFERENCE, (RichIterable<String>)((RichIterable)compare.getTwo()));
        this.output(Tuples.twin(rightClass, leftClass), DIFFERENCE, (RichIterable<String>)((RichIterable)compare.getThree()));
        return compare;
    }

    private void output(Twin<Class<?>> classPair, String operation, RichIterable<String> strings) {
        this.outputTitle(operation + " (" + this.classNames(classPair) + ")");
        this.outputGroupByToString(strings);
    }

    private String classNames(Twin<Class<?>> classPair) {
        Class left = (Class)classPair.getOne();
        Class right = (Class)classPair.getTwo();
        return (this.includePackageNames ? left.getName() : left.getSimpleName()) + ", " + (this.includePackageNames ? right.getName() : right.getSimpleName());
    }

    public MutableSortedSet<String> getMethodNames(Class<?> classOne) {
        return (MutableSortedSet)ArrayIterate.collectIf((Object[])classOne.getMethods(), this::includeMethod, this::methodName, (Collection)SortedSets.mutable.empty());
    }

    public void includeObjectMethods() {
        this.includeObjectMethods = true;
    }

    private boolean includeMethod(Method method) {
        return this.includeObjectMethods || !method.getDeclaringClass().equals(Object.class);
    }

    private String methodName(Method method) {
        String methodNamePlusParams = this.includeParameterTypesInMethods ? method.getName() + "(" + this.parameterNames(method) + ")" : method.getName();
        return methodNamePlusParams + (this.includeReturnTypes ? ":" + method.getReturnType().getSimpleName() : "");
    }

    private String parameterNames(Method method) {
        return ArrayIterate.collect((Object[])method.getParameters(), (Function & Serializable)parm -> parm.getType().getSimpleName()).makeString();
    }

    private void outputTitle(String title) {
        try {
            this.appendable.append(title).append(System.lineSeparator());
            this.appendable.append(StringIterate.repeat((char)'-', (int)title.length())).append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException("MethodComparer error in outputTitle", e);
        }
    }

    private void outputGroupByToString(RichIterable<String> methods) {
        String output = methods.groupBy((Function & Serializable)string -> Character.valueOf(string.charAt(0))).keyMultiValuePairsView().toSortedListBy(Pair::getOne).makeString(System.lineSeparator());
        try {
            this.appendable.append(output).append(System.lineSeparator());
            this.appendable.append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException("MethodComparer error in outputGroupByToString", e);
        }
    }
}

