/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;

public class CookieGenerator {
    public static final long COOKIE_LIFETIME_NANOS = TimeUnit.SECONDS.toNanos(60L);
    private long nextKeyGenerationNanos;
    private SecretKey currentSecretKey;
    private SecretKey pastSecretKey;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final SecureRandom randomGenerator = new SecureRandom();
    private final byte[] randomBytes = new byte[32];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getSecretKey() {
        this.lock.readLock().lock();
        long now = ClockUtil.nanoRealtime();
        try {
            if (this.currentSecretKey != null && now - this.nextKeyGenerationNanos < 0L) {
                SecretKey secretKey = this.currentSecretKey;
                return secretKey;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.currentSecretKey != null && now - this.nextKeyGenerationNanos < 0L) {
                SecretKey secretKey = this.currentSecretKey;
                return secretKey;
            }
            this.randomGenerator.nextBytes(this.randomBytes);
            this.nextKeyGenerationNanos = now + COOKIE_LIFETIME_NANOS;
            this.pastSecretKey = this.currentSecretKey;
            SecretKey secretKey = this.currentSecretKey = SecretUtil.create(this.randomBytes, "MAC");
            return secretKey;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getPastSecretKey() {
        this.lock.readLock().lock();
        try {
            SecretKey secretKey = this.pastSecretKey;
            return secretKey;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private byte[] generateCookie(InetSocketAddress peer, ClientHello clientHello, SecretKey secretKey) throws GeneralSecurityException {
        Mac hmac = CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256.getThreadLocalMac();
        hmac.init(secretKey);
        hmac.update(peer.getAddress().getAddress());
        int port = peer.getPort();
        hmac.update((byte)(port >>> 8));
        hmac.update((byte)port);
        clientHello.updateForCookie(hmac);
        return hmac.doFinal();
    }

    public byte[] generateCookie(InetSocketAddress peer, ClientHello clientHello) throws GeneralSecurityException {
        return this.generateCookie(peer, clientHello, this.getSecretKey());
    }

    public byte[] generatePastCookie(InetSocketAddress peer, ClientHello clientHello) throws GeneralSecurityException {
        SecretKey secretKey = this.getPastSecretKey();
        if (secretKey != null) {
            return this.generateCookie(peer, clientHello, secretKey);
        }
        return null;
    }
}

