/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.UriQueryParameter;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;

public class Echo
extends CoapResource {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MMM-HH:mm:ss");
    private static final String RESOURCE_NAME = "echo";
    private static final String URI_QUERY_OPTION_RESPONSE_LENGTH = "rlen";
    private static final String URI_QUERY_OPTION_ACK = "ack";
    private static final String URI_QUERY_OPTION_DELAY = "delay";
    private static final String URI_QUERY_OPTION_KEEP = "keep";
    private static final String URI_QUERY_OPTION_ID = "id";
    private static final List<String> SUPPORTED = Arrays.asList("ack", "delay", "rlen", "keep", "id");
    private static final int MAX_PENDING_RESPONSES = 1000;
    private final int maxResourceSize;
    private final ScheduledExecutorService executor;
    private final AtomicInteger pendingResponses = new AtomicInteger();
    private final LeastRecentlyUpdatedCache<String, Resource> keptPosts = new LeastRecentlyUpdatedCache(100, 500, 6L, TimeUnit.HOURS);

    public Echo(Configuration config, ScheduledExecutorService executor) {
        super(RESOURCE_NAME);
        this.executor = executor;
        this.maxResourceSize = config.get(CoapConfig.MAX_RESOURCE_BODY_SIZE);
        this.getAttributes().setTitle("Resource, which echo's a POST. POSTs with URI-query 'keep' can later be read by GET");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(42);
        this.getAttributes().addContentType(40);
    }

    @Override
    public void add(Resource child) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean delete(Resource child) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Resource getChild(String name) {
        return this.keptPosts.get(name);
    }

    @Override
    public Collection<Resource> getChildren() {
        return this.keptPosts.values();
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        int accept = request.getOptions().getAccept();
        if (accept != -1 && accept != 40) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
        } else {
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(LinkFormat.serializeTree(this));
            response.getOptions().setContentFormat(40);
            exchange.respond(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePOST(final CoapExchange exchange) {
        byte[] responsePayload;
        Request request = exchange.advanced().getRequest();
        int format = request.getOptions().getContentFormat();
        if (format != -1 && format != 0 && format != 42) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        int accept = request.getOptions().getAccept();
        if (accept == -1) {
            accept = format == -1 ? 42 : format;
        } else if (format == -1) {
            if (accept != 0 && accept != 42) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
        } else if (accept != format) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        boolean ack = false;
        boolean keep = false;
        String id = null;
        int length = 0;
        int delay = 0;
        try {
            UriQueryParameter helper = request.getOptions().getUriQueryParameter(SUPPORTED);
            ack = helper.hasParameter(URI_QUERY_OPTION_ACK);
            length = helper.getArgumentAsInteger(URI_QUERY_OPTION_RESPONSE_LENGTH, 0, 0, this.maxResourceSize);
            delay = helper.getArgumentAsInteger(URI_QUERY_OPTION_DELAY, 0, 0, (int)TimeUnit.SECONDS.toMillis(3600L));
            keep = helper.hasParameter(URI_QUERY_OPTION_KEEP);
            id = helper.getArgument(URI_QUERY_OPTION_ID, null);
        }
        catch (IllegalArgumentException ex) {
            exchange.respond(CoAP.ResponseCode.BAD_OPTION, ex.getMessage());
            return;
        }
        if (ack) {
            exchange.accept();
        }
        byte[] payload = request.getPayload();
        byte[] byArray = responsePayload = length == 0 ? payload : Arrays.copyOf(payload, length);
        if (length > payload.length) {
            Arrays.fill(responsePayload, payload.length, length, (byte)42);
        }
        if (keep) {
            String principal = Echo.getPrincipalName(request);
            if (principal == null) {
                principal = id;
            }
            if (principal != null) {
                request.setProtectFromOffload();
                ReentrantReadWriteLock.WriteLock lock = this.keptPosts.writeLock();
                lock.lock();
                try {
                    Resource child = this.keptPosts.update(principal);
                    if (!(child instanceof Keep)) {
                        child = new Keep(principal);
                    }
                    ((Keep)child).setPost(request);
                    if (child.getParent() == null) {
                        child.setParent(this);
                        this.keptPosts.put(principal, child);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        int responseFormat = accept;
        final Response response = new Response(CoAP.ResponseCode.CHANGED);
        response.setPayload(responsePayload);
        response.getOptions().setContentFormat(responseFormat);
        if (delay > 0 && this.executor != null) {
            boolean schedule = false;
            if (this.pendingResponses.get() < 999) {
                if (this.pendingResponses.incrementAndGet() < 1000) {
                    schedule = true;
                } else {
                    this.pendingResponses.decrementAndGet();
                }
            }
            if (schedule) {
                Runnable respond = new Runnable(){

                    @Override
                    public void run() {
                        exchange.respond(response);
                        Echo.this.pendingResponses.decrementAndGet();
                    }
                };
                this.executor.schedule(respond, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                exchange.respond(CoAP.ResponseCode.SERVICE_UNAVAILABLE, "Too many delayed responses pending!");
            }
        } else {
            exchange.respond(response);
        }
    }

    private static String getPrincipalName(Request request) {
        Principal principal = request.getSourceContext().getPeerIdentity();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    private class Keep
    extends CoapResource {
        private volatile Request post;

        private Keep(String principal) {
            super(principal);
            this.setObservable(true);
        }

        public void setPost(Request post) {
            this.post = post;
            ResourceAttributes attributes = this.getAttributes();
            attributes.clearContentType();
            if (post.getOptions().hasContentFormat()) {
                attributes.addContentType(post.getOptions().getContentFormat());
            }
            attributes.setAttribute("time", DATE_FORMAT.format(new Date()));
            attributes.setAttribute("scheme", post.getScheme());
            this.changed();
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            Request devicePost = this.post;
            Request request = exchange.advanced().getRequest();
            int format = devicePost.getOptions().getContentFormat();
            int accept = request.getOptions().getAccept();
            if (accept == -1) {
                accept = format == -1 ? 42 : format;
            } else if (format == -1) {
                if (accept != 0 && accept != 42) {
                    exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                    return;
                }
            } else if (accept != format) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(devicePost.getPayload());
            response.getOptions().setContentFormat(accept);
            exchange.respond(response);
        }

        @Override
        public void handleDELETE(CoapExchange exchange) {
            Echo.this.keptPosts.remove(this.getName(), this);
            exchange.respond(CoAP.ResponseCode.DELETED);
        }
    }
}

