/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UriQueryParameter {
    private final Map<String, String> parameterMap = new HashMap<String, String>();

    public UriQueryParameter(List<String> queryOptions) {
        this(queryOptions, null, null);
    }

    public UriQueryParameter(List<String> queryParameter, List<String> supportedParameterNames) {
        this(queryParameter, supportedParameterNames, null);
    }

    public UriQueryParameter(List<String> queryParameter, List<String> supportedParameterNames, List<String> unsupportedParameter) {
        Iterator<String> i$ = queryParameter.iterator();
        while (i$.hasNext()) {
            String parameter;
            String name = parameter = i$.next();
            String value = null;
            int index = name.indexOf(61);
            if (index >= 0) {
                name = parameter.substring(0, index);
                value = parameter.length() > index + 1 ? parameter.substring(index + 1) : "";
            }
            if (supportedParameterNames != null && !supportedParameterNames.isEmpty() && !supportedParameterNames.contains(name)) {
                if (unsupportedParameter != null) {
                    unsupportedParameter.add(parameter);
                    continue;
                }
                throw new IllegalArgumentException("URI-query-option '" + parameter + "' is not supported!");
            }
            this.parameterMap.put(name, value);
        }
    }

    public int size() {
        return this.parameterMap.size();
    }

    public boolean hasParameter(String name) {
        return this.parameterMap.containsKey(name);
    }

    public String getArgument(String name) {
        if (!this.hasParameter(name)) {
            throw new IllegalArgumentException("Missing parameter '" + name + "' in URI-query-options!");
        }
        String value = this.parameterMap.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Missing argument for URI-query-option '" + name + "'!");
        }
        return value;
    }

    public String getArgument(String name, String def) {
        String value = this.parameterMap.get(name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    private int getValueAsInteger(String name, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("URI-query-option '" + name + "=" + value + "' is no number!");
        }
    }

    public int getArgumentAsInteger(String name) {
        String value = this.getArgument(name);
        return this.getValueAsInteger(name, value);
    }

    public int getArgumentAsInteger(String name, int def) {
        String value = this.parameterMap.get(name);
        if (value != null) {
            return this.getValueAsInteger(name, value);
        }
        return def;
    }

    public int getArgumentAsInteger(String name, int def, int min) {
        int result = this.getArgumentAsInteger(name, def);
        if (result < min) {
            throw new IllegalArgumentException("URI-query-option '" + name + "=" + result + "' is less than " + min + "!");
        }
        return result;
    }

    public int getArgumentAsInteger(String name, int def, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Max. " + max + " is less then min. " + min + "!");
        }
        int result = this.getArgumentAsInteger(name, def, min);
        if (max < result) {
            throw new IllegalArgumentException("URI-query-option '" + name + "=" + result + "' is more than " + max + "!");
        }
        return result;
    }

    private long getValueAsLong(String name, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("URI-query-option '" + name + "=" + value + "' is no number!");
        }
    }

    public long getArgumentAsLong(String name) {
        String value = this.getArgument(name);
        return this.getValueAsLong(name, value);
    }

    public long getArgumentAsLong(String name, long def) {
        String value = this.parameterMap.get(name);
        if (value != null) {
            return this.getValueAsLong(name, value);
        }
        return def;
    }

    public long getArgumentAsLong(String name, long def, long min) {
        long result = this.getArgumentAsLong(name, def);
        if (result < min) {
            throw new IllegalArgumentException("URI-query-option '" + name + "=" + result + "' is less than " + min + "!");
        }
        return result;
    }

    public long getArgumentAsLong(String name, long def, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("Max. " + max + " is less then min. " + min + "!");
        }
        long result = this.getArgumentAsLong(name, def, min);
        if (max < result) {
            throw new IllegalArgumentException("URI-query-option '" + name + "=" + result + "' is more than " + max + "!");
        }
        return result;
    }
}

