/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.ExtendedCoapStackFactory;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSCoreTcpStack;
import org.eclipse.californium.oscore.OSCoreUdpStack;

public class OSCoreCoapStackFactory
implements ExtendedCoapStackFactory {
    private static AtomicBoolean init = new AtomicBoolean();
    private static volatile OSCoreCtxDB defaultCtxDb;

    @Override
    public CoapStack createCoapStack(String protocol, String tag, Configuration config, EndpointContextMatcher matchingStrategy, Outbox outbox, Object customStackArgument) {
        OSCoreCtxDB ctxDb = defaultCtxDb;
        if (customStackArgument != null) {
            if (!(customStackArgument instanceof OSCoreCtxDB)) {
                throw new IllegalArgumentException("custom argument must be a OSCoreCtxDB, not " + customStackArgument.getClass() + "!");
            }
            ctxDb = (OSCoreCtxDB)customStackArgument;
        }
        if (CoAP.isTcpProtocol(protocol)) {
            return new OSCoreTcpStack(tag, config, matchingStrategy, outbox, ctxDb);
        }
        return new OSCoreUdpStack(tag, config, matchingStrategy, outbox, ctxDb);
    }

    @Override
    public CoapStack createCoapStack(String protocol, String tag, Configuration config, Outbox outbox, Object customStackArgument) {
        return this.createCoapStack(protocol, tag, config, null, outbox, customStackArgument);
    }

    public static void useAsDefault(OSCoreCtxDB defaultCtxDb) {
        if (init.compareAndSet(false, true)) {
            CoapEndpoint.setDefaultCoapStackFactory(new OSCoreCoapStackFactory());
        }
        OSCoreCoapStackFactory.defaultCtxDb = defaultCtxDb;
    }
}

