/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

public enum ContentType {
    CHANGE_CIPHER_SPEC(20),
    ALERT(21),
    HANDSHAKE(22),
    APPLICATION_DATA(23),
    TLS12_CID(25);

    private final int code;

    public int getCode() {
        return this.code;
    }

    private ContentType(int code) {
        this.code = code;
    }

    public static ContentType getTypeByValue(int code) {
        switch (code) {
            case 20: {
                return CHANGE_CIPHER_SPEC;
            }
            case 21: {
                return ALERT;
            }
            case 22: {
                return HANDSHAKE;
            }
            case 23: {
                return APPLICATION_DATA;
            }
            case 25: {
                return TLS12_CID;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.code) {
            case 20: {
                return "Change Cipher Spec (20)";
            }
            case 21: {
                return "Alert (21)";
            }
            case 22: {
                return "Handshake (22)";
            }
            case 23: {
                return "Application Data (23)";
            }
            case 25: {
                return "TLS CID (25)";
            }
        }
        return "Unknown Content Type";
    }
}

