/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.FilteredLogger;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionEvictedException;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionStore;
import org.eclipse.californium.scandium.dtls.SingleNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class InMemoryConnectionStore
implements ResumptionSupportingConnectionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryConnectionStore.class);
    private static final FilteredLogger WARN_FILTER = new FilteredLogger(LOGGER.getName(), 3L, TimeUnit.SECONDS.toNanos(10L));
    private static final int DEFAULT_SMALL_EXTRA_CID_LENGTH = 2;
    private static final int DEFAULT_LARGE_EXTRA_CID_LENGTH = 3;
    private static final int DEFAULT_CACHE_SIZE = 150000;
    private static final long DEFAULT_EXPIRATION_THRESHOLD = 129600L;
    private static boolean SINGLE_SESSION_STORE = true;
    private final SessionStore sessionStore;
    protected final LeastRecentlyUsedCache<ConnectionId, Connection> connections;
    protected final ConcurrentMap<InetSocketAddress, Connection> connectionsByAddress;
    protected final ConcurrentMap<SessionId, Connection> connectionsByEstablishedSession;
    private ConnectionListener connectionListener;
    private ConnectionIdGenerator connectionIdGenerator;
    protected String tag = "";

    public InMemoryConnectionStore() {
        this(150000, 129600L, null);
    }

    public InMemoryConnectionStore(SessionStore sessionStore) {
        this(150000, 129600L, sessionStore);
    }

    public InMemoryConnectionStore(int capacity, long threshold) {
        this(capacity, threshold, null);
    }

    public InMemoryConnectionStore(int capacity, long threshold, SessionStore sessionStore) {
        this.connections = new LeastRecentlyUsedCache(capacity, threshold);
        this.connections.setEvictingOnReadAccess(false);
        this.connections.setUpdatingOnReadAccess(false);
        this.connectionsByAddress = new ConcurrentHashMap<InetSocketAddress, Connection>();
        this.sessionStore = sessionStore;
        this.connectionsByEstablishedSession = SINGLE_SESSION_STORE && sessionStore != null ? null : new ConcurrentHashMap<SessionId, Connection>();
        this.connections.addEvictionListener(new LeastRecentlyUsedCache.EvictionListener<Connection>(){

            @Override
            public void onEviction(final Connection staleConnection) {
                Runnable remove = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Handshaker handshaker = staleConnection.getOngoingHandshake();
                        if (handshaker != null) {
                            handshaker.handshakeFailed(new ConnectionEvictedException("Evicted!"));
                        }
                        InMemoryConnectionStore inMemoryConnectionStore = InMemoryConnectionStore.this;
                        synchronized (inMemoryConnectionStore) {
                            InMemoryConnectionStore.this.removeByAddressConnections(staleConnection);
                            InMemoryConnectionStore.this.removeByEstablishedSessions(staleConnection.getEstablishedSessionIdentifier(), staleConnection);
                            ConnectionListener listener = InMemoryConnectionStore.this.connectionListener;
                            if (listener != null) {
                                listener.onConnectionRemoved(staleConnection);
                            }
                        }
                    }
                };
                if (staleConnection.isExecuting()) {
                    staleConnection.getExecutor().execute(remove);
                } else {
                    remove.run();
                }
            }
        });
        LOGGER.info("Created new InMemoryConnectionStore [capacity: {}, connection expiration threshold: {}s]", (Object)capacity, (Object)threshold);
    }

    public synchronized InMemoryConnectionStore setTag(String tag) {
        this.tag = StringUtil.normalizeLoggingTag(tag);
        return this;
    }

    private ConnectionId newConnectionId() {
        for (int i = 0; i < 10; ++i) {
            ConnectionId cid = this.connectionIdGenerator.createConnectionId();
            if (this.connections.get(cid) != null) continue;
            return cid;
        }
        return null;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener = listener;
    }

    @Override
    public void attach(ConnectionIdGenerator connectionIdGenerator) {
        int bits;
        int cidLength;
        if (this.connectionIdGenerator != null) {
            throw new IllegalStateException("Connection id generator already attached!");
        }
        this.connectionIdGenerator = connectionIdGenerator == null || !connectionIdGenerator.useConnectionId() ? new SingleNodeConnectionIdGenerator(cidLength += (cidLength = ((bits = 32 - Integer.numberOfLeadingZeros(this.connections.getCapacity())) + 7) / 8) < 3 ? 2 : 3) : connectionIdGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Connection connection) {
        if (connection != null) {
            if (!connection.isExecuting()) {
                throw new IllegalStateException("Connection is not executing!");
            }
            ConnectionId connectionId = connection.getConnectionId();
            if (connectionId == null) {
                if (this.connectionIdGenerator == null) {
                    throw new IllegalStateException("Connection id generator must be attached before!");
                }
                connectionId = this.newConnectionId();
                if (connectionId == null) {
                    throw new IllegalStateException("Connection ids exhausted!");
                }
                connection.setConnectionId(connectionId);
            } else {
                if (connectionId.isEmpty()) {
                    throw new IllegalStateException("Connection must have a none empty connection id!");
                }
                if (this.connections.get(connectionId) != null) {
                    throw new IllegalStateException("Connection id already used! " + connectionId);
                }
            }
            DTLSSession session = connection.getEstablishedSession();
            boolean success = false;
            InMemoryConnectionStore inMemoryConnectionStore = this;
            synchronized (inMemoryConnectionStore) {
                if (this.connections.put(connectionId, connection)) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("{}connection: add {} (size {})", this.tag, connection, this.connections.size(), new Throwable("connection added!"));
                    } else {
                        LOGGER.debug("{}connection: add {} (size {})", this.tag, connectionId, this.connections.size());
                    }
                    this.addToAddressConnections(connection);
                    if (session != null) {
                        this.addToEstablishedConnections(session.getSessionIdentifier(), connection);
                    }
                    success = true;
                } else {
                    WARN_FILTER.debug("{}connection store is full! {} max. entries.", this.tag, this.connections.getCapacity());
                }
            }
            if (success && this.sessionStore != null && session != null) {
                this.sessionStore.put(session);
            }
            return success;
        }
        return false;
    }

    @Override
    public synchronized boolean update(Connection connection, InetSocketAddress newPeerAddress) {
        if (connection == null) {
            return false;
        }
        if (this.connections.update(connection.getConnectionId())) {
            connection.refreshAutoResumptionTime();
            if (newPeerAddress == null) {
                LOGGER.debug("{}connection: {} updated usage!", (Object)this.tag, (Object)connection.getConnectionId());
            } else if (!connection.equalsPeerAddress(newPeerAddress)) {
                InetSocketAddress oldPeerAddress = connection.getPeerAddress();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}connection: {} updated, address changed from {} to {}!", this.tag, connection.getConnectionId(), StringUtil.toLog(oldPeerAddress), StringUtil.toLog(newPeerAddress), new Throwable("connection updated!"));
                } else {
                    LOGGER.debug("{}connection: {} updated, address changed from {} to {}!", this.tag, connection.getConnectionId(), StringUtil.toLog(oldPeerAddress), StringUtil.toLog(newPeerAddress));
                }
                if (oldPeerAddress != null) {
                    this.connectionsByAddress.remove(oldPeerAddress, connection);
                    connection.updatePeerAddress(null);
                }
                connection.updatePeerAddress(newPeerAddress);
                this.addToAddressConnections(connection);
            }
            return true;
        }
        LOGGER.debug("{}connection: {} - {} update failed!", this.tag, connection.getConnectionId(), StringUtil.toLog(newPeerAddress));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEstablishedSession(Connection connection) {
        SessionId sessionId;
        DTLSSession session = connection.getEstablishedSession();
        if (session == null) {
            throw new IllegalArgumentException("connection has no established session!");
        }
        ConnectionListener listener = this.connectionListener;
        if (listener != null) {
            listener.onConnectionEstablished(connection);
        }
        if (!(sessionId = session.getSessionIdentifier()).isEmpty()) {
            InMemoryConnectionStore inMemoryConnectionStore = this;
            synchronized (inMemoryConnectionStore) {
                this.addToEstablishedConnections(sessionId, connection);
            }
            if (this.sessionStore != null) {
                this.sessionStore.put(session);
            }
        }
    }

    @Override
    public synchronized void removeFromEstablishedSessions(Connection connection) {
        SessionId sessionId = connection.getEstablishedSessionIdentifier();
        if (sessionId == null) {
            throw new IllegalArgumentException("connection has no established session!");
        }
        this.removeByEstablishedSessions(sessionId, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DTLSSession find(SessionId id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        DTLSSession session = null;
        if (this.sessionStore != null) {
            session = this.sessionStore.get(id);
        }
        InMemoryConnectionStore inMemoryConnectionStore = this;
        synchronized (inMemoryConnectionStore) {
            Connection connection = this.findLocally(id);
            if (connection != null) {
                if (this.sessionStore == null) {
                    DTLSSession establishedSession = connection.getEstablishedSession();
                    if (establishedSession != null) {
                        session = new DTLSSession(establishedSession);
                    }
                } else if (session == null) {
                    this.remove(connection, false);
                    return null;
                }
            }
        }
        return session;
    }

    private Connection findLocally(SessionId id) {
        if (id == null) {
            throw new NullPointerException("DTLS Session ID must not be null!");
        }
        if (this.connectionsByEstablishedSession == null) {
            return null;
        }
        Connection connection = (Connection)this.connectionsByEstablishedSession.get(id);
        if (connection != null) {
            SessionId establishedId = connection.getEstablishedSessionIdentifier();
            if (establishedId != null) {
                if (!id.equals(establishedId)) {
                    LOGGER.warn("{}connection {} changed session {}!={}!", this.tag, connection.getConnectionId(), id, establishedId);
                }
            } else {
                LOGGER.warn("{}connection {} lost session {}!", this.tag, connection.getConnectionId(), id);
            }
            this.connections.update(connection.getConnectionId());
        }
        return connection;
    }

    @Override
    public synchronized void markAllAsResumptionRequired() {
        for (Connection connection : this.connections.values()) {
            if (connection.getPeerAddress() == null || connection.isResumptionRequired()) continue;
            connection.setResumptionRequired(true);
            LOGGER.trace("{}connection: mark for resumption {}!", (Object)this.tag, (Object)connection);
        }
    }

    @Override
    public synchronized int remainingCapacity() {
        int remaining = this.connections.remainingCapacity();
        LOGGER.debug("{}connection: size {}, remaining {}!", this.tag, this.connections.size(), remaining);
        return remaining;
    }

    @Override
    public synchronized Connection get(InetSocketAddress peerAddress) {
        Connection connection = (Connection)this.connectionsByAddress.get(peerAddress);
        if (connection == null) {
            LOGGER.trace("{}connection: missing connection for {}!", (Object)this.tag, StringUtil.toLog(peerAddress));
        } else {
            InetSocketAddress address = connection.getPeerAddress();
            if (address == null) {
                LOGGER.warn("{}connection {} lost ip-address {}!", this.tag, connection.getConnectionId(), StringUtil.toLog(peerAddress));
            } else if (!address.equals(peerAddress)) {
                LOGGER.warn("{}connection {} changed ip-address {}!={}!", this.tag, connection.getConnectionId(), StringUtil.toLog(peerAddress), StringUtil.toLog(address));
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection get(ConnectionId cid) {
        Connection connection;
        InMemoryConnectionStore inMemoryConnectionStore = this;
        synchronized (inMemoryConnectionStore) {
            connection = this.connections.get(cid);
        }
        if (connection == null) {
            LOGGER.debug("{}connection: missing connection for {}!", (Object)this.tag, (Object)cid);
        } else {
            ConnectionId connectionId = connection.getConnectionId();
            if (connectionId == null) {
                LOGGER.warn("{}connection lost cid {}!", (Object)this.tag, (Object)cid);
            } else if (!connectionId.equals(cid)) {
                LOGGER.warn("{}connection changed cid {}!={}!", this.tag, connectionId, cid);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Connection connection, boolean removeFromSessionCache) {
        boolean removed;
        SessionId sessionId = connection.getEstablishedSessionIdentifier();
        InMemoryConnectionStore inMemoryConnectionStore = this;
        synchronized (inMemoryConnectionStore) {
            boolean bl = removed = this.connections.remove(connection.getConnectionId(), connection) == connection;
            if (removed) {
                int pendings = connection.shutdown();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}connection: remove {} (size {}, left jobs: {})", this.tag, connection, this.connections.size(), pendings, new Throwable("connection removed!"));
                } else if (pendings == 0) {
                    LOGGER.debug("{}connection: remove {} (size {})", this.tag, connection, this.connections.size());
                } else {
                    LOGGER.debug("{}connection: remove {} (size {}, left jobs: {})", this.tag, connection, this.connections.size(), pendings);
                }
                connection.startByClientHello(null);
                this.removeByAddressConnections(connection);
                this.removeByEstablishedSessions(sessionId, connection);
                ConnectionListener listener = this.connectionListener;
                if (listener != null) {
                    listener.onConnectionRemoved(connection);
                }
                SecretUtil.destroy(connection.getDtlsContext());
            }
        }
        if (removeFromSessionCache) {
            this.removeSessionFromStore(sessionId);
        }
        return removed;
    }

    private void removeByEstablishedSessions(SessionId sessionId, Connection connection) {
        if (this.connectionsByEstablishedSession != null && sessionId != null && !sessionId.isEmpty()) {
            this.connectionsByEstablishedSession.remove(sessionId, connection);
        }
    }

    private void removeByAddressConnections(Connection connection) {
        InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            this.connectionsByAddress.remove(peerAddress, connection);
            connection.updatePeerAddress(null);
        }
    }

    private void removeSessionFromStore(SessionId sessionId) {
        if (this.sessionStore != null && sessionId != null && !sessionId.isEmpty()) {
            this.sessionStore.remove(sessionId);
        }
    }

    private void addToAddressConnections(Connection connection) {
        final InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            final Connection previous = this.connectionsByAddress.put(peerAddress, connection);
            if (previous != null && previous != connection) {
                Runnable removeAddress = new Runnable(){

                    @Override
                    public void run() {
                        if (previous.equalsPeerAddress(peerAddress)) {
                            previous.updatePeerAddress(null);
                            if (InMemoryConnectionStore.this.connectionsByEstablishedSession == null && !previous.expectCid()) {
                                InMemoryConnectionStore.this.remove(previous, false);
                            }
                        }
                    }
                };
                LOGGER.debug("{}connection: {} - {} added! {} removed from address.", this.tag, connection.getConnectionId(), StringUtil.toLog(peerAddress), previous.getConnectionId());
                if (previous.isExecuting()) {
                    previous.getExecutor().execute(removeAddress);
                } else {
                    removeAddress.run();
                }
            } else {
                LOGGER.debug("{}connection: {} - {} added!", this.tag, connection.getConnectionId(), StringUtil.toLog(peerAddress));
            }
        } else {
            LOGGER.debug("{}connection: {} - missing address!", (Object)this.tag, (Object)connection.getConnectionId());
        }
    }

    private void addToEstablishedConnections(SessionId sessionId, Connection connection) {
        Connection previous;
        if (this.connectionsByEstablishedSession != null && (previous = this.connectionsByEstablishedSession.put(sessionId, connection)) != null && previous != connection) {
            Runnable removePreviousConnection = new Runnable(){

                @Override
                public void run() {
                    InMemoryConnectionStore.this.remove(previous, false);
                }
            };
            if (previous.isExecuting()) {
                previous.getExecutor().execute(removePreviousConnection);
            } else {
                removePreviousConnection.run();
            }
        }
    }

    @Override
    public final synchronized void clear() {
        for (Connection connection : this.connections.values()) {
            SerialExecutor executor = connection.getExecutor();
            if (executor == null) continue;
            executor.shutdownNow();
        }
        this.connections.clear();
        if (this.connectionsByEstablishedSession != null) {
            this.connectionsByEstablishedSession.clear();
        }
        this.connectionsByAddress.clear();
    }

    @Override
    public final synchronized void stop(List<Runnable> pending) {
        for (Connection connection : this.connections.values()) {
            SerialExecutor executor = connection.getExecutor();
            if (executor == null) continue;
            executor.shutdownNow(pending);
        }
    }

    @Override
    public Iterator<Connection> iterator() {
        return this.connections.valuesIterator(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveConnections(OutputStream out, long maxQuietPeriodInSeconds) throws IOException {
        int size = this.connections.size();
        int progress = size / 20;
        int count = 0;
        DatagramWriter writer = new DatagramWriter(4096);
        long startNanos = ClockUtil.nanoRealtime();
        boolean writeProgress = false;
        long progressNanos = startNanos;
        LeastRecentlyUsedCache<ConnectionId, Connection> leastRecentlyUsedCache = this.connections;
        synchronized (leastRecentlyUsedCache) {
            Iterator<LeastRecentlyUsedCache.Timestamped<Connection>> iterator = this.connections.timestampedIterator();
            while (iterator.hasNext()) {
                LeastRecentlyUsedCache.Timestamped<Connection> connection = iterator.next();
                long updateNanos = connection.getLastUpdate();
                long quiet = TimeUnit.NANOSECONDS.toSeconds(startNanos - updateNanos);
                if (quiet > maxQuietPeriodInSeconds) {
                    LOGGER.trace("{}skip {} ts, {}s too quiet!", this.tag, updateNanos, quiet);
                    continue;
                }
                LOGGER.trace("{}write {} ts, {}s ", this.tag, updateNanos, quiet);
                if (connection.getValue().writeTo(writer)) {
                    writer.writeTo(out);
                    ++count;
                } else {
                    writer.reset();
                }
                if (progress > 100 && count % progress == 0) {
                    writeProgress = true;
                }
                if (!writeProgress) continue;
                long now = ClockUtil.nanoRealtime();
                if (!writeProgress || now - progressNanos <= TimeUnit.SECONDS.toNanos(2L)) continue;
                LOGGER.info("{}written {} connections of {}", this.tag, count, size);
                writeProgress = false;
                progressNanos = now;
            }
        }
        SerializationUtil.writeNoItem(out);
        out.flush();
        writer.close();
        this.clear();
        return count;
    }

    @Override
    public int loadConnections(InputStream in, long delta) throws IOException {
        boolean clear = true;
        int count = 0;
        long startNanos = ClockUtil.nanoRealtime();
        DataStreamReader reader = new DataStreamReader(in);
        long progressNanos = startNanos;
        try {
            Connection connection;
            while ((connection = Connection.fromReader(reader, delta)) != null) {
                long lastUpdate = connection.getLastMessageNanos();
                if (lastUpdate - startNanos > 0L) {
                    WARN_FILTER.warn("{}read {} ts is after {} (future)", this.tag, lastUpdate, startNanos);
                }
                LOGGER.trace("{}read {} ts, {}s", this.tag, lastUpdate, TimeUnit.NANOSECONDS.toSeconds(startNanos - lastUpdate));
                this.restore(connection);
                ++count;
                long now = ClockUtil.nanoRealtime();
                if (now - progressNanos <= TimeUnit.SECONDS.toNanos(2L)) continue;
                LOGGER.info("{}read {} connections", (Object)this.tag, (Object)count);
                progressNanos = now;
            }
            clear = false;
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("{}reading failed after {} connections", this.tag, count, ex);
            this.clear();
            throw ex;
        }
        finally {
            if (clear) {
                this.clear();
                count = 0;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(Connection connection) {
        ConnectionId connectionId = connection.getConnectionId();
        if (connectionId == null) {
            throw new IllegalStateException("Connection must have a connection id!");
        }
        if (connectionId.isEmpty()) {
            throw new IllegalStateException("Connection must have a none empty connection id!");
        }
        if (this.connections.get(connectionId) != null) {
            throw new IllegalStateException("Connection id already used! " + connectionId);
        }
        boolean restored = false;
        LeastRecentlyUsedCache<ConnectionId, Connection> leastRecentlyUsedCache = this.connections;
        synchronized (leastRecentlyUsedCache) {
            if (this.connections.put(connectionId, connection, connection.getLastMessageNanos())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}connection: add {} (size {})", this.tag, connection, this.connections.size(), new Throwable("connection added!"));
                } else {
                    LOGGER.debug("{}connection: add {} (size {})", this.tag, connectionId, this.connections.size());
                }
                this.addToAddressConnections(connection);
                restored = true;
            } else {
                LOGGER.warn("{}connection store is full! {} max. entries.", (Object)this.tag, (Object)this.connections.getCapacity());
            }
        }
        if (restored && connection.hasEstablishedDtlsContext()) {
            this.putEstablishedSession(connection);
        }
        return restored;
    }
}

