/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.examples;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.logging.Level;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.ScandiumLogger;
import org.eclipse.californium.scandium.dtls.pskstore.StaticPskStore;

public class ExampleDTLSClient {
    private static final int DEFAULT_PORT = 5684;
    private static final String TRUST_STORE_PASSWORD = "rootPass";
    private static final String KEY_STORE_PASSWORD = "endPass";
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";
    private DTLSConnector dtlsConnector;

    public ExampleDTLSClient() {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream in = new FileInputStream(KEY_STORE_LOCATION);
            keyStore.load(in, KEY_STORE_PASSWORD.toCharArray());
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream inTrust = new FileInputStream(TRUST_STORE_LOCATION);
            trustStore.load(inTrust, TRUST_STORE_PASSWORD.toCharArray());
            Certificate[] trustedCertificates = new Certificate[]{trustStore.getCertificate("root")};
            this.dtlsConnector = new DTLSConnector(new InetSocketAddress(0), trustedCertificates);
            this.dtlsConnector.getConfig().setPskStore(new StaticPskStore("Client_identity", "secretPSK".getBytes()));
            this.dtlsConnector.getConfig().setPrivateKey((PrivateKey)keyStore.getKey("client", KEY_STORE_PASSWORD.toCharArray()), keyStore.getCertificateChain("client"), true);
            this.dtlsConnector.setRawDataReceiver(new RawDataChannelImpl());
        }
        catch (IOException | GeneralSecurityException e) {
            System.err.println("Could not load the keystore");
            e.printStackTrace();
        }
    }

    public void test() {
        try {
            this.dtlsConnector.start();
            this.dtlsConnector.send(new RawData("HELLO WORLD".getBytes(), InetAddress.getByName("localhost"), 5684));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        ExampleDTLSClient client = new ExampleDTLSClient();
        client.test();
        Class<ExampleDTLSClient> clazz = ExampleDTLSClient.class;
        synchronized (ExampleDTLSClient.class) {
            ExampleDTLSClient.class.wait();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        ScandiumLogger.initialize();
        ScandiumLogger.setLevel(Level.FINE);
    }

    private class RawDataChannelImpl
    implements RawDataChannel {
        private RawDataChannelImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveData(RawData raw) {
            System.out.println(new String(raw.getBytes()));
            ExampleDTLSClient.this.dtlsConnector.close(new InetSocketAddress("localhost", 5684));
            Class<ExampleDTLSClient> clazz = ExampleDTLSClient.class;
            synchronized (ExampleDTLSClient.class) {
                ExampleDTLSClient.class.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

