/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public enum CipherSuite {
    SSL_NULL_WITH_NULL_NULL("SSL_NULL_WITH_NULL_NULL", 0, KeyExchangeAlgorithm.NULL, BulkCipherAlgorithm.NULL, MACAlgorithm.NULL, PRFAlgorithm.TLS_PRF_SHA256, CipherType.NULL),
    TLS_PSK_WITH_AES_128_CCM_8("TLS_PSK_WITH_AES_128_CCM_8", 49320, KeyExchangeAlgorithm.PSK, BulkCipherAlgorithm.AES, MACAlgorithm.NULL, PRFAlgorithm.TLS_PRF_SHA256, CipherType.AEAD),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8("TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, BulkCipherAlgorithm.AES, MACAlgorithm.NULL, PRFAlgorithm.TLS_PRF_SHA256, CipherType.AEAD);

    private static final Logger LOGGER;
    private static final int CIPHER_SUITE_BITS = 16;
    private String name;
    private int code;
    private KeyExchangeAlgorithm keyExchange;
    private BulkCipherAlgorithm bulkCipher;
    private MACAlgorithm macAlgorithm;
    private PRFAlgorithm pseudoRandomFunction;
    private CipherType cipherType;

    private CipherSuite(String name, int code, KeyExchangeAlgorithm keyExchange, BulkCipherAlgorithm bulkCipher, MACAlgorithm macAlgorithm, PRFAlgorithm prf, CipherType cipherType) {
        this.name = name;
        this.code = code;
        this.keyExchange = keyExchange;
        this.bulkCipher = bulkCipher;
        this.macAlgorithm = macAlgorithm;
        this.pseudoRandomFunction = prf;
        this.cipherType = cipherType;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public KeyExchangeAlgorithm getKeyExchange() {
        return this.keyExchange;
    }

    public BulkCipherAlgorithm getBulkCipher() {
        return this.bulkCipher;
    }

    public MACAlgorithm getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public PRFAlgorithm getPseudoRandomFunction() {
        return this.pseudoRandomFunction;
    }

    public CipherType getCipherType() {
        return this.cipherType;
    }

    public static CipherSuite getTypeByCode(int code) {
        switch (code) {
            case 0: {
                return SSL_NULL_WITH_NULL_NULL;
            }
            case 49320: {
                return TLS_PSK_WITH_AES_128_CCM_8;
            }
            case 49326: {
                return TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8;
            }
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Unknown cipher suite code, fallback to SSL_NULL_WITH_NULL_NULL: " + code);
        }
        return SSL_NULL_WITH_NULL_NULL;
    }

    public static byte[] listToByteArray(List<CipherSuite> cipherSuites) {
        DatagramWriter writer = new DatagramWriter();
        for (CipherSuite cipherSuite : cipherSuites) {
            writer.write(cipherSuite.getCode(), 16);
        }
        return writer.toByteArray();
    }

    public static List<CipherSuite> listFromByteArray(byte[] byteArray, int numElements) {
        ArrayList<CipherSuite> cipherSuites = new ArrayList<CipherSuite>();
        DatagramReader reader = new DatagramReader(byteArray);
        for (int i = 0; i < numElements; ++i) {
            int code = reader.read(16);
            cipherSuites.add(CipherSuite.getTypeByCode(code));
        }
        return cipherSuites;
    }

    static {
        LOGGER = Logger.getLogger(CipherSuite.class.getCanonicalName());
    }

    public static enum CipherType {
        NULL,
        STREAM,
        BLOCK,
        AEAD;

    }

    public static enum PRFAlgorithm {
        TLS_PRF_SHA256;

    }

    public static enum KeyExchangeAlgorithm {
        NULL,
        DHE_DSS,
        DHE_RSA,
        DH_ANON,
        RSA,
        DH_DSS,
        DH_RSA,
        PSK,
        EC_DIFFIE_HELLMAN;

    }

    public static enum BulkCipherAlgorithm {
        NULL(0, 0, 0, 0),
        RC4(0, 16, 4, 8),
        B_3DES(0, 16, 4, 8),
        AES(0, 16, 4, 8);

        private int macKeyLength;
        private int encKeyLength;
        private int fixedIvLength;
        private int recordIvLength;

        private BulkCipherAlgorithm(int mac_key_length, int enc_key_length, int fixed_iv_length, int recordIvLength) {
            this.macKeyLength = mac_key_length;
            this.encKeyLength = enc_key_length;
            this.fixedIvLength = fixed_iv_length;
            this.recordIvLength = recordIvLength;
        }

        public int getMacKeyLength() {
            return this.macKeyLength;
        }

        public int getEncKeyLength() {
            return this.encKeyLength;
        }

        public int getFixedIvLength() {
            return this.fixedIvLength;
        }

        public int getRecordIvLength() {
            return this.recordIvLength;
        }
    }

    public static enum MACAlgorithm {
        NULL,
        HMAC_MD5,
        HMAC_SHA1,
        HMAC_SHA256,
        HMAC_SHA384,
        HMAC_SHA512;

    }
}

