/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class SupportedPointFormatsExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 8;
    private static final int POINT_FORMAT_BITS = 8;
    List<ECPointFormat> ecPointFormatList;

    public SupportedPointFormatsExtension(List<ECPointFormat> ecPointFormatList) {
        super(HelloExtension.ExtensionType.EC_POINT_FORMATS);
        this.ecPointFormatList = ecPointFormatList;
    }

    public void addECPointFormat(ECPointFormat format) {
        this.ecPointFormatList.add(format);
    }

    @Override
    public int getLength() {
        return 5 + this.ecPointFormatList.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tLength: " + (this.getLength() - 4) + "\n");
        sb.append("\t\t\t\tEC point formats length: " + (this.getLength() - 5) + "\n");
        sb.append("\t\t\t\tElliptic Curves Point Formats (" + this.ecPointFormatList.size() + "):\n");
        for (ECPointFormat format : this.ecPointFormatList) {
            sb.append("\t\t\t\t\tEC point format: " + format.toString() + "\n");
        }
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.writeBytes(super.toByteArray());
        int listLength = this.ecPointFormatList.size();
        writer.write(listLength + 1, 16);
        writer.write(listLength, 8);
        for (ECPointFormat format : this.ecPointFormatList) {
            writer.write(format.getId(), 8);
        }
        return writer.toByteArray();
    }

    public static HelloExtension fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        ArrayList<ECPointFormat> ecPointFormatList = new ArrayList<ECPointFormat>();
        for (int listLength = reader.read(8); listLength > 0; --listLength) {
            ECPointFormat format = ECPointFormat.getECPointFormatById(reader.read(8));
            ecPointFormatList.add(format);
        }
        return new SupportedPointFormatsExtension(ecPointFormatList);
    }

    public static enum ECPointFormat {
        UNCOMPRESSED(0),
        ANSIX962_COMPRESSED_PRIME(1),
        ANSIX962_COMPRESSED_CHAR2(2);

        private int id;

        private ECPointFormat(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "uncompressed (" + this.id + ")";
                }
                case 1: {
                    return "ansiX962_compressed_prime (" + this.id + ")";
                }
                case 2: {
                    return "ansiX962_compressed_char2 (" + this.id + ")";
                }
            }
            return "";
        }

        public static ECPointFormat getECPointFormatById(int id) {
            switch (id) {
                case 0: {
                    return UNCOMPRESSED;
                }
                case 1: {
                    return ANSIX962_COMPRESSED_PRIME;
                }
                case 2: {
                    return ANSIX962_COMPRESSED_CHAR2;
                }
            }
            return null;
        }
    }
}

