/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.eclipse.californium.scandium.DTLSConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerHello;

public class ResumingServerHandshaker
extends ServerHandshaker {
    private byte[] handshakeHash;

    public ResumingServerHandshaker(InetSocketAddress endpointAddress, DTLSSession session, Certificate[] rootCerts, DTLSConnectorConfig config) {
        super(endpointAddress, session, rootCerts, config);
        this.setSessionToResume(session);
    }

    private void setSessionToResume(DTLSSession session) {
        session.setActive(false);
        session.setWriteEpoch(0);
        session.setReadEpoch(0);
    }

    @Override
    public synchronized DTLSFlight processMessage(Record record) throws HandshakeException {
        DTLSFlight flight = null;
        if (!this.processMessageNext(record)) {
            return null;
        }
        block0 : switch (record.getType()) {
            case ALERT: {
                record.getFragment();
                break;
            }
            case CHANGE_CIPHER_SPEC: {
                record.getFragment();
                this.setCurrentReadState();
                this.session.incrementReadEpoch();
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage fragment = (HandshakeMessage)record.getFragment();
                switch (fragment.getMessageType()) {
                    case CLIENT_HELLO: {
                        flight = this.receivedClientHello((ClientHello)fragment);
                        break block0;
                    }
                    case FINISHED: {
                        this.receivedClientFinished((Finished)fragment);
                        break block0;
                    }
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
                throw new HandshakeException("Server received unexpected resuming handshake message:\n" + fragment.toString(), alert);
            }
            default: {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Server received not supported record:\n" + record.toString(), alert);
            }
        }
        if (flight == null) {
            Record nextMessage = null;
            for (Record queuedMessage : this.queuedMessages) {
                if (!this.processMessageNext(queuedMessage)) continue;
                nextMessage = queuedMessage;
            }
            if (nextMessage != null) {
                flight = this.processMessage(nextMessage);
            }
        }
        LOGGER.fine("DTLS Message processed (" + this.endpointAddress.toString() + "):\n" + record.toString());
        return flight;
    }

    private DTLSFlight receivedClientHello(ClientHello message) {
        DTLSFlight flight = new DTLSFlight();
        this.md.update(message.toByteArray());
        this.clientRandom = message.getRandom();
        this.serverRandom = new Random(new SecureRandom());
        ServerHello serverHello = new ServerHello(message.getClientVersion(), this.serverRandom, this.session.getSessionIdentifier(), this.session.getCipherSuite(), this.session.getCompressionMethod(), null);
        flight.addMessage(this.wrapMessage(serverHello));
        this.md.update(serverHello.toByteArray());
        this.generateKeys(this.session.getMasterSecret());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.session.incrementWriteEpoch();
        MessageDigest mdWithServerFinished = null;
        try {
            mdWithServerFinished = (MessageDigest)this.md.clone();
        }
        catch (Exception e) {
            LOGGER.severe("Clone not supported.");
            e.printStackTrace();
        }
        this.handshakeHash = this.md.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, this.handshakeHash);
        flight.addMessage(this.wrapMessage(finished));
        mdWithServerFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithServerFinished.digest();
        return flight;
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        message.verifyData(this.getMasterSecret(), false, this.handshakeHash);
    }
}

