/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.scandium.DTLSConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.ServerHello;

public class ResumingClientHandshaker
extends ClientHandshaker {
    public ResumingClientHandshaker(InetSocketAddress endpointAddress, RawData message, DTLSSession session, Certificate[] rootCerts, DTLSConnectorConfig config) {
        super(endpointAddress, message, session, rootCerts, config);
    }

    @Override
    public synchronized DTLSFlight processMessage(Record record) throws HandshakeException {
        if (this.lastFlight != null) {
            LOGGER.finer("Received server's finished message again, retransmit the last flight.");
            return this.lastFlight;
        }
        DTLSFlight flight = null;
        if (!this.processMessageNext(record)) {
            return null;
        }
        block0 : switch (record.getType()) {
            case ALERT: {
                record.getFragment();
                break;
            }
            case CHANGE_CIPHER_SPEC: {
                record.getFragment();
                this.setCurrentReadState();
                this.session.incrementReadEpoch();
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage fragment = (HandshakeMessage)record.getFragment();
                switch (fragment.getMessageType()) {
                    case SERVER_HELLO: {
                        this.serverHello = (ServerHello)fragment;
                        break block0;
                    }
                    case FINISHED: {
                        flight = this.receivedServerFinished((Finished)fragment);
                        break block0;
                    }
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
                throw new HandshakeException("Client received unexpected resuming handshake message:\n" + fragment.toString(), alert);
            }
            default: {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Client received not supported record:\n" + record.toString(), alert);
            }
        }
        if (flight == null) {
            Record nextMessage = null;
            for (Record queuedMessage : this.queuedMessages) {
                if (!this.processMessageNext(queuedMessage)) continue;
                nextMessage = queuedMessage;
            }
            if (nextMessage != null) {
                flight = this.processMessage(nextMessage);
            }
        }
        LOGGER.fine("DTLS Message processed (" + this.endpointAddress.toString() + "):\n" + record.toString());
        return flight;
    }

    private DTLSFlight receivedServerFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return null;
        }
        DTLSFlight flight = new DTLSFlight();
        this.md.update(this.clientHello.toByteArray());
        this.md.update(this.serverHello.toByteArray());
        MessageDigest mdWithServerFinish = null;
        try {
            mdWithServerFinish = (MessageDigest)this.md.clone();
        }
        catch (Exception e) {
            LOGGER.severe("Clone not supported.");
            e.printStackTrace();
        }
        mdWithServerFinish.update(message.toByteArray());
        this.handshakeHash = this.md.digest();
        message.verifyData(this.getMasterSecret(), false, this.handshakeHash);
        this.clientRandom = this.clientHello.getRandom();
        this.serverRandom = this.serverHello.getRandom();
        this.generateKeys(this.session.getMasterSecret());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.session.incrementWriteEpoch();
        this.handshakeHash = mdWithServerFinish.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, this.handshakeHash);
        flight.addMessage(this.wrapMessage(finished));
        this.state = HandshakeType.FINISHED.getCode();
        this.session.setActive(true);
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        return flight;
    }

    @Override
    public DTLSFlight getStartHandshakeMessage() {
        ClientHello message = new ClientHello(new ProtocolVersion(), new SecureRandom(), this.session);
        message.addCipherSuite(this.session.getCipherSuite());
        message.addCompressionMethod(this.session.getCompressionMethod());
        this.state = message.getMessageType().getCode();
        this.clientHello = message;
        DTLSFlight flight = new DTLSFlight();
        flight.addMessage(this.wrapMessage(message));
        return flight;
    }
}

