/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.util.DatagramWriter;

public abstract class HelloExtension {
    protected static final int TYPE_BITS = 16;
    protected static final int LENGTH_BITS = 16;
    private ExtensionType type;

    public HelloExtension(ExtensionType type) {
        this.type = type;
    }

    public abstract int getLength();

    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.type.getId(), 16);
        return writer.toByteArray();
    }

    public static HelloExtension fromByteArray(int typeCode, byte[] extension) throws HandshakeException {
        ExtensionType type = ExtensionType.getExtensionTypeById(typeCode);
        if (type == null) {
            return null;
        }
        switch (type) {
            case ELLIPTIC_CURVES: {
                return SupportedEllipticCurvesExtension.fromByteArray(extension);
            }
            case EC_POINT_FORMATS: {
                return SupportedPointFormatsExtension.fromByteArray(extension);
            }
            case CLIENT_CERT_TYPE: {
                return ClientCertificateTypeExtension.fromByteArray(extension);
            }
            case SERVER_CERT_TYPE: {
                return ServerCertificateTypeExtension.fromByteArray(extension);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t\tExtension: " + this.type.toString() + " (" + this.type.getId() + ")\n");
        return sb.toString();
    }

    protected ExtensionType getType() {
        return this.type;
    }

    public static enum ExtensionType {
        SERVER_NAME(0, "server_name"),
        MAX_FRAGMENT_LENGTH(1, "max_fragment_length"),
        CLIENT_CERTIFICATE_URL(2, "client_certificate_url"),
        TRUSTED_CA_KEYS(3, "trusted_ca_keys"),
        TRUNCATED_HMAC(4, "truncated_hmac"),
        STATUS_REQUEST(5, "status_request"),
        USER_MAPPING(6, "user_mapping"),
        CLIENT_AUTHZ(7, "client_authz"),
        SERVER_AUTHZ(8, "server_authz"),
        CERT_TYPE(9, "cert_type"),
        ELLIPTIC_CURVES(10, "elliptic_curves"),
        EC_POINT_FORMATS(11, "ec_point_formats"),
        SRP(12, "srp"),
        SIGNATURE_ALGORITHMS(13, "signature_algorithms"),
        USE_SRTP(14, "use_srtp"),
        HEARTBEAT(15, "heartbeat"),
        APPLICATION_LAYER_PROTOCOL_NEGOTIATION(16, "application_layer_protocol_negotiation"),
        STATUS_REQUEST_V2(17, "status_request_v2"),
        SIGNED_CERTIFICATE_TIMESTAMP(18, "signed_certificate_timestamp"),
        CLIENT_CERT_TYPE(19, "client_certificate_type"),
        SERVER_CERT_TYPE(20, "server_certificate_type"),
        ENCRYPT_THEN_MAC(22, "encrypt_then_mac"),
        SESSION_TICKET_TLS(35, "SessionTicket TLS"),
        RENEGOTIATION_INFO(65281, "renegotiation_info");

        private int id;
        private String name;

        private ExtensionType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static ExtensionType getExtensionTypeById(int id) {
            switch (id) {
                case 0: {
                    return SERVER_NAME;
                }
                case 1: {
                    return MAX_FRAGMENT_LENGTH;
                }
                case 2: {
                    return CLIENT_CERTIFICATE_URL;
                }
                case 3: {
                    return TRUSTED_CA_KEYS;
                }
                case 4: {
                    return TRUNCATED_HMAC;
                }
                case 5: {
                    return STATUS_REQUEST;
                }
                case 6: {
                    return USER_MAPPING;
                }
                case 7: {
                    return CLIENT_AUTHZ;
                }
                case 8: {
                    return SERVER_AUTHZ;
                }
                case 9: {
                    return CERT_TYPE;
                }
                case 10: {
                    return ELLIPTIC_CURVES;
                }
                case 11: {
                    return EC_POINT_FORMATS;
                }
                case 12: {
                    return SRP;
                }
                case 13: {
                    return SIGNATURE_ALGORITHMS;
                }
                case 14: {
                    return USE_SRTP;
                }
                case 15: {
                    return HEARTBEAT;
                }
                case 16: {
                    return APPLICATION_LAYER_PROTOCOL_NEGOTIATION;
                }
                case 17: {
                    return STATUS_REQUEST_V2;
                }
                case 18: {
                    return SIGNED_CERTIFICATE_TIMESTAMP;
                }
                case 19: {
                    return CLIENT_CERT_TYPE;
                }
                case 20: {
                    return SERVER_CERT_TYPE;
                }
                case 22: {
                    return ENCRYPT_THEN_MAC;
                }
                case 35: {
                    return SESSION_TICKET_TLS;
                }
                case 65281: {
                    return RENEGOTIATION_INFO;
                }
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

