/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.logging.Level;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.scandium.DTLSConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class ClientHandshaker
extends Handshaker {
    private ProtocolVersion maxProtocolVersion = new ProtocolVersion();
    private PublicKey serverPublicKey;
    private ECPublicKey ephemeralServerPublicKey;
    protected ClientHello clientHello = null;
    private final CipherSuite preferredCipherSuite;
    private final boolean useRawPublicKey;
    protected ServerHello serverHello;
    protected CertificateMessage serverCertificate = null;
    protected CertificateRequest certificateRequest = null;
    protected ServerKeyExchange serverKeyExchange = null;
    protected ServerHelloDone serverHelloDone;
    protected byte[] handshakeHash = null;
    protected final PskStore pskStore;

    public ClientHandshaker(InetSocketAddress endpointAddress, RawData message, DTLSSession session, Certificate[] rootCerts, DTLSConnectorConfig config) {
        super(endpointAddress, true, session, rootCerts);
        this.message = message;
        this.privateKey = config.privateKey;
        this.certificates = config.certChain;
        this.publicKey = this.certificates != null && this.certificates.length > 0 ? this.certificates[0].getPublicKey() : config.publicKey;
        this.pskStore = config.pskStore;
        this.useRawPublicKey = config.sendRawKey;
        this.preferredCipherSuite = config.preferredCipherSuite;
    }

    @Override
    public synchronized DTLSFlight processMessage(Record record) throws HandshakeException {
        DTLSFlight flight = null;
        if (!this.processMessageNext(record)) {
            return null;
        }
        block0 : switch (record.getType()) {
            case ALERT: {
                record.getFragment();
                break;
            }
            case CHANGE_CIPHER_SPEC: {
                record.getFragment();
                this.setCurrentReadState();
                this.session.incrementReadEpoch();
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage fragment = (HandshakeMessage)record.getFragment();
                if (fragment instanceof FragmentedHandshakeMessage) {
                    if ((fragment = this.handleFragmentation((FragmentedHandshakeMessage)fragment)) == null) break;
                    record.setFragment(fragment);
                }
                switch (fragment.getMessageType()) {
                    case HELLO_REQUEST: {
                        flight = this.receivedHelloRequest((HelloRequest)fragment);
                        break block0;
                    }
                    case HELLO_VERIFY_REQUEST: {
                        flight = this.receivedHelloVerifyRequest((HelloVerifyRequest)fragment);
                        break block0;
                    }
                    case SERVER_HELLO: {
                        this.receivedServerHello((ServerHello)fragment);
                        break block0;
                    }
                    case CERTIFICATE: {
                        this.receivedServerCertificate((CertificateMessage)fragment);
                        break block0;
                    }
                    case SERVER_KEY_EXCHANGE: {
                        switch (this.keyExchange) {
                            case EC_DIFFIE_HELLMAN: {
                                this.receivedServerKeyExchange((ECDHServerKeyExchange)fragment);
                                break block0;
                            }
                            case PSK: {
                                this.serverKeyExchange = (PSKServerKeyExchange)fragment;
                                break block0;
                            }
                            case NULL: {
                                LOGGER.info("Received unexpected ServerKeyExchange message in NULL key exchange mode.");
                                break block0;
                            }
                        }
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                        throw new HandshakeException("Not supported server key exchange algorithm: " + (Object)((Object)this.keyExchange), alert);
                    }
                    case CERTIFICATE_REQUEST: {
                        this.certificateRequest = (CertificateRequest)fragment;
                        break block0;
                    }
                    case SERVER_HELLO_DONE: {
                        flight = this.receivedServerHelloDone((ServerHelloDone)fragment);
                        break block0;
                    }
                    case FINISHED: {
                        flight = this.receivedServerFinished((Finished)fragment);
                        break block0;
                    }
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
                throw new HandshakeException("Client received unexpected handshake message:\n" + fragment.toString(), alert);
            }
            default: {
                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Client received not supported record:\n" + record.toString(), alertMessage);
            }
        }
        if (flight == null) {
            Record nextMessage = null;
            for (Record queuedMessage : this.queuedMessages) {
                if (!this.processMessageNext(queuedMessage)) continue;
                nextMessage = queuedMessage;
            }
            if (nextMessage != null) {
                flight = this.processMessage(nextMessage);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("DTLS Message processed (" + this.endpointAddress.toString() + "):\n" + record.toString());
        }
        return flight;
    }

    private DTLSFlight receivedServerFinished(Finished message) throws HandshakeException {
        DTLSFlight flight = new DTLSFlight();
        message.verifyData(this.getMasterSecret(), false, this.handshakeHash);
        this.state = HandshakeType.FINISHED.getCode();
        this.session.setActive(true);
        ApplicationMessage applicationMessage = new ApplicationMessage(this.message.getBytes());
        flight.addMessage(this.wrapMessage(applicationMessage));
        flight.setRetransmissionNeeded(false);
        return flight;
    }

    private DTLSFlight receivedHelloRequest(HelloRequest message) {
        if (this.state < HandshakeType.HELLO_REQUEST.getCode()) {
            return this.getStartHandshakeMessage();
        }
        return null;
    }

    private DTLSFlight receivedHelloVerifyRequest(HelloVerifyRequest message) {
        this.clientHello.setCookie(message.getCookie());
        this.clientHello.setFragmentLength(this.clientHello.getMessageLength());
        DTLSFlight flight = new DTLSFlight();
        flight.addMessage(this.wrapMessage(this.clientHello));
        return flight;
    }

    private void receivedServerHello(ServerHello message) {
        ServerCertificateTypeExtension serverCertType;
        if (this.serverHello != null && message.getMessageSeq() == this.serverHello.getMessageSeq()) {
            return;
        }
        this.serverHello = message;
        this.usedProtocol = message.getServerVersion();
        this.serverRandom = message.getRandom();
        this.session.setSessionIdentifier(message.getSessionId());
        this.setCipherSuite(message.getCipherSuite());
        this.setCompressionMethod(message.getCompressionMethod());
        ClientCertificateTypeExtension clientCertType = this.serverHello.getClientCertificateTypeExtension();
        if (clientCertType != null && clientCertType.getCertificateTypes().get(0) == CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY) {
            this.session.setReceiveRawPublicKey(true);
        }
        if ((serverCertType = this.serverHello.getServerCertificateTypeExtension()) != null && serverCertType.getCertificateTypes().get(0) == CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY) {
            this.session.setSendRawPublicKey(true);
        }
    }

    private void receivedServerCertificate(CertificateMessage message) throws HandshakeException {
        if (this.serverCertificate != null && this.serverCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.serverCertificate = message;
        this.serverPublicKey = this.serverCertificate.getPublicKey();
        this.session.setPeerRawPublicKey(this.serverPublicKey);
        this.serverCertificate.verifyCertificate(this.rootCertificates);
    }

    private void receivedServerKeyExchange(ECDHServerKeyExchange message) throws HandshakeException {
        if (this.serverKeyExchange != null && this.serverKeyExchange.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.serverKeyExchange = message;
        message.verifySignature(this.serverPublicKey, this.clientRandom, this.serverRandom);
        ECParameterSpec params = ECDHServerKeyExchange.NAMED_CURVE_PARAMETERS.get(message.getCurveId());
        if (params == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("Server used unsupported elliptic curve for ECDH", alert);
        }
        this.ephemeralServerPublicKey = message.getPublicKey(params);
        this.ecdhe = new ECDHECryptography(this.ephemeralServerPublicKey.getParams());
    }

    private DTLSFlight receivedServerHelloDone(ServerHelloDone message) throws HandshakeException {
        DTLSFlight flight = new DTLSFlight();
        if (this.serverHelloDone != null && this.serverHelloDone.getMessageSeq() == message.getMessageSeq()) {
            return flight;
        }
        this.serverHelloDone = message;
        CertificateMessage clientCertificate = null;
        ClientKeyExchange clientKeyExchange = null;
        HandshakeMessage certificateVerify = null;
        if (this.certificateRequest != null) {
            clientCertificate = this.session.sendRawPublicKey() ? new CertificateMessage(this.publicKey.getEncoded()) : new CertificateMessage(this.certificates);
            flight.addMessage(this.wrapMessage(clientCertificate));
        }
        switch (this.keyExchange) {
            case EC_DIFFIE_HELLMAN: {
                clientKeyExchange = new ECDHClientKeyExchange(this.ecdhe.getPublicKey());
                byte[] premasterSecret = this.ecdhe.getSecret(this.ephemeralServerPublicKey).getEncoded();
                this.generateKeys(premasterSecret);
                break;
            }
            case PSK: {
                String identity = this.pskStore.getIdentity(this.endpointAddress);
                if (identity == null) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                    throw new HandshakeException("No Identity found for peer: " + this.endpointAddress, alert);
                }
                this.session.setPskIdentity(identity);
                byte[] psk = this.pskStore.getKey(identity);
                if (psk == null) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                    throw new HandshakeException("No preshared secret found for identity: " + identity, alert);
                }
                clientKeyExchange = new PSKClientKeyExchange(identity);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Using PSK identity: " + identity);
                }
                byte[] premasterSecret = this.generatePremasterSecretFromPSK(psk);
                this.generateKeys(premasterSecret);
                break;
            }
            case NULL: {
                clientKeyExchange = new NULLClientKeyExchange();
                this.generateKeys(new byte[0]);
                break;
            }
            default: {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Unknown key exchange algorithm: " + (Object)((Object)this.keyExchange), alert);
            }
        }
        flight.addMessage(this.wrapMessage(clientKeyExchange));
        if (this.certificateRequest != null) {
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientHello.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverHello.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverCertificate.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverKeyExchange.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.certificateRequest.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverHelloDone.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, clientCertificate.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, clientKeyExchange.toByteArray());
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = this.certificateRequest.getSupportedSignatureAlgorithms().get(0);
            certificateVerify = new CertificateVerify(signatureAndHashAlgorithm, this.privateKey, this.handshakeMessages);
            flight.addMessage(this.wrapMessage(certificateVerify));
        }
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.session.incrementWriteEpoch();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(this.clientHello.toByteArray());
            md.update(this.serverHello.toByteArray());
            if (this.serverCertificate != null) {
                md.update(this.serverCertificate.toByteArray());
            }
            if (this.serverKeyExchange != null) {
                md.update(this.serverKeyExchange.toByteArray());
            }
            if (this.certificateRequest != null) {
                md.update(this.certificateRequest.toByteArray());
            }
            md.update(this.serverHelloDone.toByteArray());
            if (clientCertificate != null) {
                md.update(clientCertificate.toByteArray());
            }
            md.update(clientKeyExchange.toByteArray());
            if (certificateVerify != null) {
                md.update(certificateVerify.toByteArray());
            }
            MessageDigest mdWithClientFinished = null;
            try {
                mdWithClientFinished = (MessageDigest)md.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.log(Level.SEVERE, "Clone not supported.", e);
            }
            this.handshakeHash = md.digest();
            Finished finished = new Finished(this.getMasterSecret(), this.isClient, this.handshakeHash);
            flight.addMessage(this.wrapMessage(finished));
            mdWithClientFinished.update(finished.toByteArray());
            this.handshakeHash = mdWithClientFinished.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "No such Message Digest Algorithm available.", e);
        }
        return flight;
    }

    @Override
    public DTLSFlight getStartHandshakeMessage() {
        ClientHello message = new ClientHello(this.maxProtocolVersion, new SecureRandom(), this.useRawPublicKey);
        this.clientRandom = message.getRandom();
        if (this.preferredCipherSuite == CipherSuite.TLS_PSK_WITH_AES_128_CCM_8) {
            message.addCipherSuite(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8);
            message.addCipherSuite(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
        } else {
            message.addCipherSuite(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
            message.addCipherSuite(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8);
        }
        message.addCompressionMethod(CompressionMethod.NULL);
        this.state = message.getMessageType().getCode();
        this.clientHello = message;
        DTLSFlight flight = new DTLSFlight();
        flight.addMessage(this.wrapMessage(message));
        return flight;
    }
}

